/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspacedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.finspacedata.model.ColumnDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnDefinition> {
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(ColumnDefinition.getter(ColumnDefinition::dataTypeAsString)).setter(ColumnDefinition.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("columnName").getter(ColumnDefinition.getter(ColumnDefinition::columnName)).setter(ColumnDefinition.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnName").build()}).build();
    private static final SdkField<String> COLUMN_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("columnDescription").getter(ColumnDefinition.getter(ColumnDefinition::columnDescription)).setter(ColumnDefinition.setter(Builder::columnDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TYPE_FIELD, COLUMN_NAME_FIELD, COLUMN_DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataType;
    private final String columnName;
    private final String columnDescription;

    private ColumnDefinition(BuilderImpl builder) {
        this.dataType = builder.dataType;
        this.columnName = builder.columnName;
        this.columnDescription = builder.columnDescription;
    }

    public final ColumnDataType dataType() {
        return ColumnDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final String columnDescription() {
        return this.columnDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnDefinition)) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)obj;
        return Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.columnDescription(), other.columnDescription());
    }

    public final String toString() {
        return ToString.builder((String)"ColumnDefinition").add("DataType", (Object)this.dataTypeAsString()).add("ColumnName", (Object)this.columnName()).add("ColumnDescription", (Object)this.columnDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "columnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "columnDescription": {
                return Optional.ofNullable(clazz.cast(this.columnDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnDefinition, T> g) {
        return obj -> g.apply((ColumnDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataType;
        private String columnName;
        private String columnDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnDefinition model) {
            this.dataType(model.dataType);
            this.columnName(model.columnName);
            this.columnDescription(model.columnDescription);
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(ColumnDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnDescription() {
            return this.columnDescription;
        }

        public final void setColumnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
        }

        @Override
        public final Builder columnDescription(String columnDescription) {
            this.columnDescription = columnDescription;
            return this;
        }

        public ColumnDefinition build() {
            return new ColumnDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnDefinition> {
        public Builder dataType(String var1);

        public Builder dataType(ColumnDataType var1);

        public Builder columnName(String var1);

        public Builder columnDescription(String var1);
    }
}

