/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeBaseClientBuilder;
import software.amazon.awssdk.services.eventbridge.DefaultEventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;
import software.amazon.awssdk.services.eventbridge.EventBridgeClientBuilder;
import software.amazon.awssdk.services.eventbridge.EventBridgeServiceClientConfiguration;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;

@SdkInternalApi
final class DefaultEventBridgeClientBuilder
extends DefaultEventBridgeBaseClientBuilder<EventBridgeClientBuilder, EventBridgeClient>
implements EventBridgeClientBuilder {
    DefaultEventBridgeClientBuilder() {
    }

    @Override
    public DefaultEventBridgeClientBuilder endpointProvider(EventBridgeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EventBridgeClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEventBridgeClientBuilder.validateClientOptions(clientConfiguration);
        EventBridgeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEventBridgeClient client = new DefaultEventBridgeClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EventBridgeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EventBridgeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

