/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeRequest;
import software.amazon.awssdk.services.eventbridge.model.ReplayDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReplayRequest
extends EventBridgeRequest
implements ToCopyableBuilder<Builder, StartReplayRequest> {
    private static final SdkField<String> REPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplayName").getter(StartReplayRequest.getter(StartReplayRequest::replayName)).setter(StartReplayRequest.setter(Builder::replayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplayName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartReplayRequest.getter(StartReplayRequest::description)).setter(StartReplayRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSourceArn").getter(StartReplayRequest.getter(StartReplayRequest::eventSourceArn)).setter(StartReplayRequest.setter(Builder::eventSourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSourceArn").build()}).build();
    private static final SdkField<Instant> EVENT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventStartTime").getter(StartReplayRequest.getter(StartReplayRequest::eventStartTime)).setter(StartReplayRequest.setter(Builder::eventStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventStartTime").build()}).build();
    private static final SdkField<Instant> EVENT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventEndTime").getter(StartReplayRequest.getter(StartReplayRequest::eventEndTime)).setter(StartReplayRequest.setter(Builder::eventEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventEndTime").build()}).build();
    private static final SdkField<ReplayDestination> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Destination").getter(StartReplayRequest.getter(StartReplayRequest::destination)).setter(StartReplayRequest.setter(Builder::destination)).constructor(ReplayDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLAY_NAME_FIELD, DESCRIPTION_FIELD, EVENT_SOURCE_ARN_FIELD, EVENT_START_TIME_FIELD, EVENT_END_TIME_FIELD, DESTINATION_FIELD));
    private final String replayName;
    private final String description;
    private final String eventSourceArn;
    private final Instant eventStartTime;
    private final Instant eventEndTime;
    private final ReplayDestination destination;

    private StartReplayRequest(BuilderImpl builder) {
        super(builder);
        this.replayName = builder.replayName;
        this.description = builder.description;
        this.eventSourceArn = builder.eventSourceArn;
        this.eventStartTime = builder.eventStartTime;
        this.eventEndTime = builder.eventEndTime;
        this.destination = builder.destination;
    }

    public final String replayName() {
        return this.replayName;
    }

    public final String description() {
        return this.description;
    }

    public final String eventSourceArn() {
        return this.eventSourceArn;
    }

    public final Instant eventStartTime() {
        return this.eventStartTime;
    }

    public final Instant eventEndTime() {
        return this.eventEndTime;
    }

    public final ReplayDestination destination() {
        return this.destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.replayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReplayRequest)) {
            return false;
        }
        StartReplayRequest other = (StartReplayRequest)((Object)obj);
        return Objects.equals(this.replayName(), other.replayName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.eventSourceArn(), other.eventSourceArn()) && Objects.equals(this.eventStartTime(), other.eventStartTime()) && Objects.equals(this.eventEndTime(), other.eventEndTime()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"StartReplayRequest").add("ReplayName", (Object)this.replayName()).add("Description", (Object)this.description()).add("EventSourceArn", (Object)this.eventSourceArn()).add("EventStartTime", (Object)this.eventStartTime()).add("EventEndTime", (Object)this.eventEndTime()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplayName": {
                return Optional.ofNullable(clazz.cast(this.replayName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EventSourceArn": {
                return Optional.ofNullable(clazz.cast(this.eventSourceArn()));
            }
            case "EventStartTime": {
                return Optional.ofNullable(clazz.cast(this.eventStartTime()));
            }
            case "EventEndTime": {
                return Optional.ofNullable(clazz.cast(this.eventEndTime()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartReplayRequest, T> g) {
        return obj -> g.apply((StartReplayRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeRequest.BuilderImpl
    implements Builder {
        private String replayName;
        private String description;
        private String eventSourceArn;
        private Instant eventStartTime;
        private Instant eventEndTime;
        private ReplayDestination destination;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReplayRequest model) {
            super(model);
            this.replayName(model.replayName);
            this.description(model.description);
            this.eventSourceArn(model.eventSourceArn);
            this.eventStartTime(model.eventStartTime);
            this.eventEndTime(model.eventEndTime);
            this.destination(model.destination);
        }

        public final String getReplayName() {
            return this.replayName;
        }

        public final void setReplayName(String replayName) {
            this.replayName = replayName;
        }

        @Override
        public final Builder replayName(String replayName) {
            this.replayName = replayName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventSourceArn() {
            return this.eventSourceArn;
        }

        public final void setEventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
        }

        @Override
        public final Builder eventSourceArn(String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        public final Instant getEventStartTime() {
            return this.eventStartTime;
        }

        public final void setEventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
        }

        @Override
        public final Builder eventStartTime(Instant eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public final Instant getEventEndTime() {
            return this.eventEndTime;
        }

        public final void setEventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
        }

        @Override
        public final Builder eventEndTime(Instant eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public final ReplayDestination.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        public final void setDestination(ReplayDestination.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        @Override
        public final Builder destination(ReplayDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReplayRequest build() {
            return new StartReplayRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EventBridgeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReplayRequest> {
        public Builder replayName(String var1);

        public Builder description(String var1);

        public Builder eventSourceArn(String var1);

        public Builder eventStartTime(Instant var1);

        public Builder eventEndTime(Instant var1);

        public Builder destination(ReplayDestination var1);

        default public Builder destination(Consumer<ReplayDestination.Builder> destination) {
            return this.destination((ReplayDestination)((ReplayDestination.Builder)ReplayDestination.builder().applyMutation(destination)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

