/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesRequest;
import software.amazon.awssdk.services.entityresolution.model.ListProviderServicesResponse;
import software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary;

public class ListProviderServicesPublisher
implements SdkPublisher<ListProviderServicesResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListProviderServicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProviderServicesPublisher(EntityResolutionAsyncClient client, ListProviderServicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProviderServicesPublisher(EntityResolutionAsyncClient client, ListProviderServicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProviderServicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProviderServicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProviderServiceSummary> providerServiceSummaries() {
        Function<ListProviderServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.providerServiceSummaries() != null) {
                return response.providerServiceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProviderServicesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProviderServicesResponseFetcher
    implements AsyncPageFetcher<ListProviderServicesResponse> {
        private ListProviderServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListProviderServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProviderServicesResponse> nextPage(ListProviderServicesResponse previousPage) {
            if (previousPage == null) {
                return ListProviderServicesPublisher.this.client.listProviderServices(ListProviderServicesPublisher.this.firstRequest);
            }
            return ListProviderServicesPublisher.this.client.listProviderServices((ListProviderServicesRequest)((Object)ListProviderServicesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

