/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IncrementalRunType {
    IMMEDIATE("IMMEDIATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IncrementalRunType> VALUE_MAP;
    private final String value;

    private IncrementalRunType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IncrementalRunType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IncrementalRunType> knownValues() {
        EnumSet<IncrementalRunType> knownValues = EnumSet.allOf(IncrementalRunType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IncrementalRunType.class, IncrementalRunType::toString);
    }
}

