/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.ProviderEndpointConfiguration;
import software.amazon.awssdk.services.entityresolution.model.ProviderIntermediateDataAccessConfiguration;
import software.amazon.awssdk.services.entityresolution.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProviderServiceResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetProviderServiceResponse> {
    private static final SdkField<Boolean> ANONYMIZED_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("anonymizedOutput").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::anonymizedOutput)).setter(GetProviderServiceResponse.setter(Builder::anonymizedOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anonymizedOutput").build()}).build();
    private static final SdkField<Document> PROVIDER_CONFIGURATION_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerConfigurationDefinition").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerConfigurationDefinition)).setter(GetProviderServiceResponse.setter(Builder::providerConfigurationDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfigurationDefinition").build()}).build();
    private static final SdkField<ProviderEndpointConfiguration> PROVIDER_ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerEndpointConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerEndpointConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerEndpointConfiguration)).constructor(ProviderEndpointConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEndpointConfiguration").build()}).build();
    private static final SdkField<Document> PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerEntityOutputDefinition").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerEntityOutputDefinition)).setter(GetProviderServiceResponse.setter(Builder::providerEntityOutputDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEntityOutputDefinition").build()}).build();
    private static final SdkField<ProviderIntermediateDataAccessConfiguration> PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("providerIntermediateDataAccessConfiguration").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerIntermediateDataAccessConfiguration)).setter(GetProviderServiceResponse.setter(Builder::providerIntermediateDataAccessConfiguration)).constructor(ProviderIntermediateDataAccessConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerIntermediateDataAccessConfiguration").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerName)).setter(GetProviderServiceResponse.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceArn").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceArn)).setter(GetProviderServiceResponse.setter(Builder::providerServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceDisplayName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceDisplayName)).setter(GetProviderServiceResponse.setter(Builder::providerServiceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceDisplayName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceName").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceName)).setter(GetProviderServiceResponse.setter(Builder::providerServiceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceName").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceType").getter(GetProviderServiceResponse.getter(GetProviderServiceResponse::providerServiceTypeAsString)).setter(GetProviderServiceResponse.setter(Builder::providerServiceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANONYMIZED_OUTPUT_FIELD, PROVIDER_CONFIGURATION_DEFINITION_FIELD, PROVIDER_ENDPOINT_CONFIGURATION_FIELD, PROVIDER_ENTITY_OUTPUT_DEFINITION_FIELD, PROVIDER_INTERMEDIATE_DATA_ACCESS_CONFIGURATION_FIELD, PROVIDER_NAME_FIELD, PROVIDER_SERVICE_ARN_FIELD, PROVIDER_SERVICE_DISPLAY_NAME_FIELD, PROVIDER_SERVICE_NAME_FIELD, PROVIDER_SERVICE_TYPE_FIELD));
    private final Boolean anonymizedOutput;
    private final Document providerConfigurationDefinition;
    private final ProviderEndpointConfiguration providerEndpointConfiguration;
    private final Document providerEntityOutputDefinition;
    private final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;
    private final String providerName;
    private final String providerServiceArn;
    private final String providerServiceDisplayName;
    private final String providerServiceName;
    private final String providerServiceType;

    private GetProviderServiceResponse(BuilderImpl builder) {
        super(builder);
        this.anonymizedOutput = builder.anonymizedOutput;
        this.providerConfigurationDefinition = builder.providerConfigurationDefinition;
        this.providerEndpointConfiguration = builder.providerEndpointConfiguration;
        this.providerEntityOutputDefinition = builder.providerEntityOutputDefinition;
        this.providerIntermediateDataAccessConfiguration = builder.providerIntermediateDataAccessConfiguration;
        this.providerName = builder.providerName;
        this.providerServiceArn = builder.providerServiceArn;
        this.providerServiceDisplayName = builder.providerServiceDisplayName;
        this.providerServiceName = builder.providerServiceName;
        this.providerServiceType = builder.providerServiceType;
    }

    public final Boolean anonymizedOutput() {
        return this.anonymizedOutput;
    }

    public final Document providerConfigurationDefinition() {
        return this.providerConfigurationDefinition;
    }

    public final ProviderEndpointConfiguration providerEndpointConfiguration() {
        return this.providerEndpointConfiguration;
    }

    public final Document providerEntityOutputDefinition() {
        return this.providerEntityOutputDefinition;
    }

    public final ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration() {
        return this.providerIntermediateDataAccessConfiguration;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String providerServiceArn() {
        return this.providerServiceArn;
    }

    public final String providerServiceDisplayName() {
        return this.providerServiceDisplayName;
    }

    public final String providerServiceName() {
        return this.providerServiceName;
    }

    public final ServiceType providerServiceType() {
        return ServiceType.fromValue(this.providerServiceType);
    }

    public final String providerServiceTypeAsString() {
        return this.providerServiceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anonymizedOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerConfigurationDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEndpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerEntityOutputDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerIntermediateDataAccessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProviderServiceResponse)) {
            return false;
        }
        GetProviderServiceResponse other = (GetProviderServiceResponse)((Object)obj);
        return Objects.equals(this.anonymizedOutput(), other.anonymizedOutput()) && Objects.equals(this.providerConfigurationDefinition(), other.providerConfigurationDefinition()) && Objects.equals(this.providerEndpointConfiguration(), other.providerEndpointConfiguration()) && Objects.equals(this.providerEntityOutputDefinition(), other.providerEntityOutputDefinition()) && Objects.equals(this.providerIntermediateDataAccessConfiguration(), other.providerIntermediateDataAccessConfiguration()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.providerServiceArn(), other.providerServiceArn()) && Objects.equals(this.providerServiceDisplayName(), other.providerServiceDisplayName()) && Objects.equals(this.providerServiceName(), other.providerServiceName()) && Objects.equals(this.providerServiceTypeAsString(), other.providerServiceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetProviderServiceResponse").add("AnonymizedOutput", (Object)this.anonymizedOutput()).add("ProviderConfigurationDefinition", (Object)this.providerConfigurationDefinition()).add("ProviderEndpointConfiguration", (Object)this.providerEndpointConfiguration()).add("ProviderEntityOutputDefinition", (Object)this.providerEntityOutputDefinition()).add("ProviderIntermediateDataAccessConfiguration", (Object)this.providerIntermediateDataAccessConfiguration()).add("ProviderName", (Object)this.providerName()).add("ProviderServiceArn", (Object)this.providerServiceArn()).add("ProviderServiceDisplayName", (Object)this.providerServiceDisplayName()).add("ProviderServiceName", (Object)this.providerServiceName()).add("ProviderServiceType", (Object)this.providerServiceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anonymizedOutput": {
                return Optional.ofNullable(clazz.cast(this.anonymizedOutput()));
            }
            case "providerConfigurationDefinition": {
                return Optional.ofNullable(clazz.cast(this.providerConfigurationDefinition()));
            }
            case "providerEndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerEndpointConfiguration()));
            }
            case "providerEntityOutputDefinition": {
                return Optional.ofNullable(clazz.cast(this.providerEntityOutputDefinition()));
            }
            case "providerIntermediateDataAccessConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerIntermediateDataAccessConfiguration()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "providerServiceArn": {
                return Optional.ofNullable(clazz.cast(this.providerServiceArn()));
            }
            case "providerServiceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceDisplayName()));
            }
            case "providerServiceName": {
                return Optional.ofNullable(clazz.cast(this.providerServiceName()));
            }
            case "providerServiceType": {
                return Optional.ofNullable(clazz.cast(this.providerServiceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProviderServiceResponse, T> g) {
        return obj -> g.apply((GetProviderServiceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private Boolean anonymizedOutput;
        private Document providerConfigurationDefinition;
        private ProviderEndpointConfiguration providerEndpointConfiguration;
        private Document providerEntityOutputDefinition;
        private ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration;
        private String providerName;
        private String providerServiceArn;
        private String providerServiceDisplayName;
        private String providerServiceName;
        private String providerServiceType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProviderServiceResponse model) {
            super(model);
            this.anonymizedOutput(model.anonymizedOutput);
            this.providerConfigurationDefinition(model.providerConfigurationDefinition);
            this.providerEndpointConfiguration(model.providerEndpointConfiguration);
            this.providerEntityOutputDefinition(model.providerEntityOutputDefinition);
            this.providerIntermediateDataAccessConfiguration(model.providerIntermediateDataAccessConfiguration);
            this.providerName(model.providerName);
            this.providerServiceArn(model.providerServiceArn);
            this.providerServiceDisplayName(model.providerServiceDisplayName);
            this.providerServiceName(model.providerServiceName);
            this.providerServiceType(model.providerServiceType);
        }

        public final Boolean getAnonymizedOutput() {
            return this.anonymizedOutput;
        }

        public final void setAnonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
        }

        @Override
        public final Builder anonymizedOutput(Boolean anonymizedOutput) {
            this.anonymizedOutput = anonymizedOutput;
            return this;
        }

        public final Document getProviderConfigurationDefinition() {
            return this.providerConfigurationDefinition;
        }

        public final void setProviderConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
        }

        @Override
        public final Builder providerConfigurationDefinition(Document providerConfigurationDefinition) {
            this.providerConfigurationDefinition = providerConfigurationDefinition;
            return this;
        }

        public final ProviderEndpointConfiguration.Builder getProviderEndpointConfiguration() {
            return this.providerEndpointConfiguration != null ? this.providerEndpointConfiguration.toBuilder() : null;
        }

        public final void setProviderEndpointConfiguration(ProviderEndpointConfiguration.BuilderImpl providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration != null ? providerEndpointConfiguration.build() : null;
        }

        @Override
        public final Builder providerEndpointConfiguration(ProviderEndpointConfiguration providerEndpointConfiguration) {
            this.providerEndpointConfiguration = providerEndpointConfiguration;
            return this;
        }

        public final Document getProviderEntityOutputDefinition() {
            return this.providerEntityOutputDefinition;
        }

        public final void setProviderEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
        }

        @Override
        public final Builder providerEntityOutputDefinition(Document providerEntityOutputDefinition) {
            this.providerEntityOutputDefinition = providerEntityOutputDefinition;
            return this;
        }

        public final ProviderIntermediateDataAccessConfiguration.Builder getProviderIntermediateDataAccessConfiguration() {
            return this.providerIntermediateDataAccessConfiguration != null ? this.providerIntermediateDataAccessConfiguration.toBuilder() : null;
        }

        public final void setProviderIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration.BuilderImpl providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration != null ? providerIntermediateDataAccessConfiguration.build() : null;
        }

        @Override
        public final Builder providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration providerIntermediateDataAccessConfiguration) {
            this.providerIntermediateDataAccessConfiguration = providerIntermediateDataAccessConfiguration;
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getProviderServiceArn() {
            return this.providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public final String getProviderServiceDisplayName() {
            return this.providerServiceDisplayName;
        }

        public final void setProviderServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
        }

        @Override
        public final Builder providerServiceDisplayName(String providerServiceDisplayName) {
            this.providerServiceDisplayName = providerServiceDisplayName;
            return this;
        }

        public final String getProviderServiceName() {
            return this.providerServiceName;
        }

        public final void setProviderServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
        }

        @Override
        public final Builder providerServiceName(String providerServiceName) {
            this.providerServiceName = providerServiceName;
            return this;
        }

        public final String getProviderServiceType() {
            return this.providerServiceType;
        }

        public final void setProviderServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
        }

        @Override
        public final Builder providerServiceType(String providerServiceType) {
            this.providerServiceType = providerServiceType;
            return this;
        }

        @Override
        public final Builder providerServiceType(ServiceType providerServiceType) {
            this.providerServiceType(providerServiceType == null ? null : providerServiceType.toString());
            return this;
        }

        @Override
        public GetProviderServiceResponse build() {
            return new GetProviderServiceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProviderServiceResponse> {
        public Builder anonymizedOutput(Boolean var1);

        public Builder providerConfigurationDefinition(Document var1);

        public Builder providerEndpointConfiguration(ProviderEndpointConfiguration var1);

        default public Builder providerEndpointConfiguration(Consumer<ProviderEndpointConfiguration.Builder> providerEndpointConfiguration) {
            return this.providerEndpointConfiguration((ProviderEndpointConfiguration)((ProviderEndpointConfiguration.Builder)ProviderEndpointConfiguration.builder().applyMutation(providerEndpointConfiguration)).build());
        }

        public Builder providerEntityOutputDefinition(Document var1);

        public Builder providerIntermediateDataAccessConfiguration(ProviderIntermediateDataAccessConfiguration var1);

        default public Builder providerIntermediateDataAccessConfiguration(Consumer<ProviderIntermediateDataAccessConfiguration.Builder> providerIntermediateDataAccessConfiguration) {
            return this.providerIntermediateDataAccessConfiguration((ProviderIntermediateDataAccessConfiguration)((ProviderIntermediateDataAccessConfiguration.Builder)ProviderIntermediateDataAccessConfiguration.builder().applyMutation(providerIntermediateDataAccessConfiguration)).build());
        }

        public Builder providerName(String var1);

        public Builder providerServiceArn(String var1);

        public Builder providerServiceDisplayName(String var1);

        public Builder providerServiceName(String var1);

        public Builder providerServiceType(String var1);

        public Builder providerServiceType(ServiceType var1);
    }
}

