/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrcontainers.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emrcontainers.EmrContainersClient;
import software.amazon.awssdk.services.emrcontainers.model.Endpoint;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsRequest;
import software.amazon.awssdk.services.emrcontainers.model.ListManagedEndpointsResponse;

public class ListManagedEndpointsIterable
implements SdkIterable<ListManagedEndpointsResponse> {
    private final EmrContainersClient client;
    private final ListManagedEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedEndpointsIterable(EmrContainersClient client, ListManagedEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListManagedEndpointsResponseFetcher();
    }

    public Iterator<ListManagedEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Endpoint> endpoints() {
        Function<ListManagedEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedEndpointsResponseFetcher
    implements SyncPageFetcher<ListManagedEndpointsResponse> {
        private ListManagedEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedEndpointsResponse nextPage(ListManagedEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedEndpointsIterable.this.client.listManagedEndpoints(ListManagedEndpointsIterable.this.firstRequest);
            }
            return ListManagedEndpointsIterable.this.client.listManagedEndpoints((ListManagedEndpointsRequest)((Object)ListManagedEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

