/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of a bootstrap action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BootstrapActionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<BootstrapActionConfig.Builder, BootstrapActionConfig> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(BootstrapActionConfig::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<ScriptBootstrapActionConfig> SCRIPT_BOOTSTRAP_ACTION_FIELD = SdkField
            .<ScriptBootstrapActionConfig> builder(MarshallingType.SDK_POJO).memberName("ScriptBootstrapAction")
            .getter(getter(BootstrapActionConfig::scriptBootstrapAction)).setter(setter(Builder::scriptBootstrapAction))
            .constructor(ScriptBootstrapActionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptBootstrapAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SCRIPT_BOOTSTRAP_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ScriptBootstrapActionConfig scriptBootstrapAction;

    private BootstrapActionConfig(BuilderImpl builder) {
        this.name = builder.name;
        this.scriptBootstrapAction = builder.scriptBootstrapAction;
    }

    /**
     * <p>
     * The name of the bootstrap action.
     * </p>
     * 
     * @return The name of the bootstrap action.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The script run by the bootstrap action.
     * </p>
     * 
     * @return The script run by the bootstrap action.
     */
    public final ScriptBootstrapActionConfig scriptBootstrapAction() {
        return scriptBootstrapAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(scriptBootstrapAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BootstrapActionConfig)) {
            return false;
        }
        BootstrapActionConfig other = (BootstrapActionConfig) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(scriptBootstrapAction(), other.scriptBootstrapAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BootstrapActionConfig").add("Name", name())
                .add("ScriptBootstrapAction", scriptBootstrapAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ScriptBootstrapAction":
            return Optional.ofNullable(clazz.cast(scriptBootstrapAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BootstrapActionConfig, T> g) {
        return obj -> g.apply((BootstrapActionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BootstrapActionConfig> {
        /**
         * <p>
         * The name of the bootstrap action.
         * </p>
         * 
         * @param name
         *        The name of the bootstrap action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The script run by the bootstrap action.
         * </p>
         * 
         * @param scriptBootstrapAction
         *        The script run by the bootstrap action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptBootstrapAction(ScriptBootstrapActionConfig scriptBootstrapAction);

        /**
         * <p>
         * The script run by the bootstrap action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScriptBootstrapActionConfig.Builder}
         * avoiding the need to create one manually via {@link ScriptBootstrapActionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScriptBootstrapActionConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #scriptBootstrapAction(ScriptBootstrapActionConfig)}.
         * 
         * @param scriptBootstrapAction
         *        a consumer that will call methods on {@link ScriptBootstrapActionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scriptBootstrapAction(ScriptBootstrapActionConfig)
         */
        default Builder scriptBootstrapAction(Consumer<ScriptBootstrapActionConfig.Builder> scriptBootstrapAction) {
            return scriptBootstrapAction(ScriptBootstrapActionConfig.builder().applyMutation(scriptBootstrapAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ScriptBootstrapActionConfig scriptBootstrapAction;

        private BuilderImpl() {
        }

        private BuilderImpl(BootstrapActionConfig model) {
            name(model.name);
            scriptBootstrapAction(model.scriptBootstrapAction);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ScriptBootstrapActionConfig.Builder getScriptBootstrapAction() {
            return scriptBootstrapAction != null ? scriptBootstrapAction.toBuilder() : null;
        }

        public final void setScriptBootstrapAction(ScriptBootstrapActionConfig.BuilderImpl scriptBootstrapAction) {
            this.scriptBootstrapAction = scriptBootstrapAction != null ? scriptBootstrapAction.build() : null;
        }

        @Override
        public final Builder scriptBootstrapAction(ScriptBootstrapActionConfig scriptBootstrapAction) {
            this.scriptBootstrapAction = scriptBootstrapAction;
            return this;
        }

        @Override
        public BootstrapActionConfig build() {
            return new BootstrapActionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
