/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescription;
import software.amazon.awssdk.services.elasticbeanstalk.model.ConfigurationOptionDescriptionsListCopier;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationOptionsResponse
extends ElasticBeanstalkResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
    private static final SdkField<String> SOLUTION_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SolutionStackName").getter(DescribeConfigurationOptionsResponse.getter(DescribeConfigurationOptionsResponse::solutionStackName)).setter(DescribeConfigurationOptionsResponse.setter(Builder::solutionStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionStackName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(DescribeConfigurationOptionsResponse.getter(DescribeConfigurationOptionsResponse::platformArn)).setter(DescribeConfigurationOptionsResponse.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<List<ConfigurationOptionDescription>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(DescribeConfigurationOptionsResponse.getter(DescribeConfigurationOptionsResponse::options)).setter(DescribeConfigurationOptionsResponse.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationOptionDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLUTION_STACK_NAME_FIELD, PLATFORM_ARN_FIELD, OPTIONS_FIELD));
    private final String solutionStackName;
    private final String platformArn;
    private final List<ConfigurationOptionDescription> options;

    private DescribeConfigurationOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.solutionStackName = builder.solutionStackName;
        this.platformArn = builder.platformArn;
        this.options = builder.options;
    }

    public final String solutionStackName() {
        return this.solutionStackName;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationOptionDescription> options() {
        return this.options;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solutionStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationOptionsResponse)) {
            return false;
        }
        DescribeConfigurationOptionsResponse other = (DescribeConfigurationOptionsResponse)((Object)obj);
        return Objects.equals(this.solutionStackName(), other.solutionStackName()) && Objects.equals(this.platformArn(), other.platformArn()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationOptionsResponse").add("SolutionStackName", (Object)this.solutionStackName()).add("PlatformArn", (Object)this.platformArn()).add("Options", this.hasOptions() ? this.options() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SolutionStackName": {
                return Optional.ofNullable(clazz.cast(this.solutionStackName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationOptionsResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticBeanstalkResponse.BuilderImpl
    implements Builder {
        private String solutionStackName;
        private String platformArn;
        private List<ConfigurationOptionDescription> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationOptionsResponse model) {
            super(model);
            this.solutionStackName(model.solutionStackName);
            this.platformArn(model.platformArn);
            this.options(model.options);
        }

        public final String getSolutionStackName() {
            return this.solutionStackName;
        }

        public final void setSolutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
        }

        @Override
        public final Builder solutionStackName(String solutionStackName) {
            this.solutionStackName = solutionStackName;
            return this;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final List<ConfigurationOptionDescription.Builder> getOptions() {
            List<ConfigurationOptionDescription.Builder> result = ConfigurationOptionDescriptionsListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<ConfigurationOptionDescription.BuilderImpl> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<ConfigurationOptionDescription> options) {
            this.options = ConfigurationOptionDescriptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(ConfigurationOptionDescription ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<ConfigurationOptionDescription.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (ConfigurationOptionDescription)((ConfigurationOptionDescription.Builder)ConfigurationOptionDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeConfigurationOptionsResponse build() {
            return new DescribeConfigurationOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticBeanstalkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationOptionsResponse> {
        public Builder solutionStackName(String var1);

        public Builder platformArn(String var1);

        public Builder options(Collection<ConfigurationOptionDescription> var1);

        public Builder options(ConfigurationOptionDescription ... var1);

        public Builder options(Consumer<ConfigurationOptionDescription.Builder> ... var1);
    }
}

