/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.elasticbeanstalk.DefaultElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.DefaultElasticBeanstalkBaseClientBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClientBuilder;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkServiceClientConfiguration;
import software.amazon.awssdk.services.elasticbeanstalk.endpoints.ElasticBeanstalkEndpointProvider;

@SdkInternalApi
final class DefaultElasticBeanstalkAsyncClientBuilder
extends DefaultElasticBeanstalkBaseClientBuilder<ElasticBeanstalkAsyncClientBuilder, ElasticBeanstalkAsyncClient>
implements ElasticBeanstalkAsyncClientBuilder {
    DefaultElasticBeanstalkAsyncClientBuilder() {
    }

    @Override
    public DefaultElasticBeanstalkAsyncClientBuilder endpointProvider(ElasticBeanstalkEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ElasticBeanstalkAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultElasticBeanstalkAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ElasticBeanstalkServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultElasticBeanstalkAsyncClient client = new DefaultElasticBeanstalkAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ElasticBeanstalkServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ElasticBeanstalkServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

