/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticache.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticache.model.AuthTokenUpdateStatus;
import software.amazon.awssdk.services.elasticache.model.ClusterMode;
import software.amazon.awssdk.services.elasticache.model.PendingAutomaticFailoverStatus;
import software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfiguration;
import software.amazon.awssdk.services.elasticache.model.PendingLogDeliveryConfigurationListCopier;
import software.amazon.awssdk.services.elasticache.model.ReshardingStatus;
import software.amazon.awssdk.services.elasticache.model.TransitEncryptionMode;
import software.amazon.awssdk.services.elasticache.model.UserGroupsUpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplicationGroupPendingModifiedValues
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
    private static final SdkField<String> PRIMARY_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryClusterId").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::primaryClusterId)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::primaryClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryClusterId").build()}).build();
    private static final SdkField<String> AUTOMATIC_FAILOVER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutomaticFailoverStatus").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::automaticFailoverStatusAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::automaticFailoverStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticFailoverStatus").build()}).build();
    private static final SdkField<ReshardingStatus> RESHARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Resharding").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::resharding)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::resharding)).constructor(ReshardingStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resharding").build()}).build();
    private static final SdkField<String> AUTH_TOKEN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthTokenStatus").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::authTokenStatusAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::authTokenStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthTokenStatus").build()}).build();
    private static final SdkField<UserGroupsUpdateStatus> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserGroups").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::userGroups)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::userGroups)).constructor(UserGroupsUpdateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroups").build()}).build();
    private static final SdkField<List<PendingLogDeliveryConfiguration>> LOG_DELIVERY_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogDeliveryConfigurations").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::logDeliveryConfigurations)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::logDeliveryConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDeliveryConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PendingLogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> TRANSIT_ENCRYPTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TransitEncryptionEnabled").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::transitEncryptionEnabled)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::transitEncryptionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionEnabled").build()}).build();
    private static final SdkField<String> TRANSIT_ENCRYPTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitEncryptionMode").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::transitEncryptionModeAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::transitEncryptionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitEncryptionMode").build()}).build();
    private static final SdkField<String> CLUSTER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterMode").getter(ReplicationGroupPendingModifiedValues.getter(ReplicationGroupPendingModifiedValues::clusterModeAsString)).setter(ReplicationGroupPendingModifiedValues.setter(Builder::clusterMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_CLUSTER_ID_FIELD, AUTOMATIC_FAILOVER_STATUS_FIELD, RESHARDING_FIELD, AUTH_TOKEN_STATUS_FIELD, USER_GROUPS_FIELD, LOG_DELIVERY_CONFIGURATIONS_FIELD, TRANSIT_ENCRYPTION_ENABLED_FIELD, TRANSIT_ENCRYPTION_MODE_FIELD, CLUSTER_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String primaryClusterId;
    private final String automaticFailoverStatus;
    private final ReshardingStatus resharding;
    private final String authTokenStatus;
    private final UserGroupsUpdateStatus userGroups;
    private final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations;
    private final Boolean transitEncryptionEnabled;
    private final String transitEncryptionMode;
    private final String clusterMode;

    private ReplicationGroupPendingModifiedValues(BuilderImpl builder) {
        this.primaryClusterId = builder.primaryClusterId;
        this.automaticFailoverStatus = builder.automaticFailoverStatus;
        this.resharding = builder.resharding;
        this.authTokenStatus = builder.authTokenStatus;
        this.userGroups = builder.userGroups;
        this.logDeliveryConfigurations = builder.logDeliveryConfigurations;
        this.transitEncryptionEnabled = builder.transitEncryptionEnabled;
        this.transitEncryptionMode = builder.transitEncryptionMode;
        this.clusterMode = builder.clusterMode;
    }

    public final String primaryClusterId() {
        return this.primaryClusterId;
    }

    public final PendingAutomaticFailoverStatus automaticFailoverStatus() {
        return PendingAutomaticFailoverStatus.fromValue(this.automaticFailoverStatus);
    }

    public final String automaticFailoverStatusAsString() {
        return this.automaticFailoverStatus;
    }

    public final ReshardingStatus resharding() {
        return this.resharding;
    }

    public final AuthTokenUpdateStatus authTokenStatus() {
        return AuthTokenUpdateStatus.fromValue(this.authTokenStatus);
    }

    public final String authTokenStatusAsString() {
        return this.authTokenStatus;
    }

    public final UserGroupsUpdateStatus userGroups() {
        return this.userGroups;
    }

    public final boolean hasLogDeliveryConfigurations() {
        return this.logDeliveryConfigurations != null && !(this.logDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    public final List<PendingLogDeliveryConfiguration> logDeliveryConfigurations() {
        return this.logDeliveryConfigurations;
    }

    public final Boolean transitEncryptionEnabled() {
        return this.transitEncryptionEnabled;
    }

    public final TransitEncryptionMode transitEncryptionMode() {
        return TransitEncryptionMode.fromValue(this.transitEncryptionMode);
    }

    public final String transitEncryptionModeAsString() {
        return this.transitEncryptionMode;
    }

    public final ClusterMode clusterMode() {
        return ClusterMode.fromValue(this.clusterMode);
    }

    public final String clusterModeAsString() {
        return this.clusterMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automaticFailoverStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resharding());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTokenStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitEncryptionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationGroupPendingModifiedValues)) {
            return false;
        }
        ReplicationGroupPendingModifiedValues other = (ReplicationGroupPendingModifiedValues)obj;
        return Objects.equals(this.primaryClusterId(), other.primaryClusterId()) && Objects.equals(this.automaticFailoverStatusAsString(), other.automaticFailoverStatusAsString()) && Objects.equals(this.resharding(), other.resharding()) && Objects.equals(this.authTokenStatusAsString(), other.authTokenStatusAsString()) && Objects.equals(this.userGroups(), other.userGroups()) && this.hasLogDeliveryConfigurations() == other.hasLogDeliveryConfigurations() && Objects.equals(this.logDeliveryConfigurations(), other.logDeliveryConfigurations()) && Objects.equals(this.transitEncryptionEnabled(), other.transitEncryptionEnabled()) && Objects.equals(this.transitEncryptionModeAsString(), other.transitEncryptionModeAsString()) && Objects.equals(this.clusterModeAsString(), other.clusterModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ReplicationGroupPendingModifiedValues").add("PrimaryClusterId", (Object)this.primaryClusterId()).add("AutomaticFailoverStatus", (Object)this.automaticFailoverStatusAsString()).add("Resharding", (Object)this.resharding()).add("AuthTokenStatus", (Object)this.authTokenStatusAsString()).add("UserGroups", (Object)this.userGroups()).add("LogDeliveryConfigurations", this.hasLogDeliveryConfigurations() ? this.logDeliveryConfigurations() : null).add("TransitEncryptionEnabled", (Object)this.transitEncryptionEnabled()).add("TransitEncryptionMode", (Object)this.transitEncryptionModeAsString()).add("ClusterMode", (Object)this.clusterModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryClusterId": {
                return Optional.ofNullable(clazz.cast(this.primaryClusterId()));
            }
            case "AutomaticFailoverStatus": {
                return Optional.ofNullable(clazz.cast(this.automaticFailoverStatusAsString()));
            }
            case "Resharding": {
                return Optional.ofNullable(clazz.cast(this.resharding()));
            }
            case "AuthTokenStatus": {
                return Optional.ofNullable(clazz.cast(this.authTokenStatusAsString()));
            }
            case "UserGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "LogDeliveryConfigurations": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfigurations()));
            }
            case "TransitEncryptionEnabled": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionEnabled()));
            }
            case "TransitEncryptionMode": {
                return Optional.ofNullable(clazz.cast(this.transitEncryptionModeAsString()));
            }
            case "ClusterMode": {
                return Optional.ofNullable(clazz.cast(this.clusterModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationGroupPendingModifiedValues, T> g) {
        return obj -> g.apply((ReplicationGroupPendingModifiedValues)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryClusterId;
        private String automaticFailoverStatus;
        private ReshardingStatus resharding;
        private String authTokenStatus;
        private UserGroupsUpdateStatus userGroups;
        private List<PendingLogDeliveryConfiguration> logDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Boolean transitEncryptionEnabled;
        private String transitEncryptionMode;
        private String clusterMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationGroupPendingModifiedValues model) {
            this.primaryClusterId(model.primaryClusterId);
            this.automaticFailoverStatus(model.automaticFailoverStatus);
            this.resharding(model.resharding);
            this.authTokenStatus(model.authTokenStatus);
            this.userGroups(model.userGroups);
            this.logDeliveryConfigurations(model.logDeliveryConfigurations);
            this.transitEncryptionEnabled(model.transitEncryptionEnabled);
            this.transitEncryptionMode(model.transitEncryptionMode);
            this.clusterMode(model.clusterMode);
        }

        public final String getPrimaryClusterId() {
            return this.primaryClusterId;
        }

        public final void setPrimaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
        }

        @Override
        public final Builder primaryClusterId(String primaryClusterId) {
            this.primaryClusterId = primaryClusterId;
            return this;
        }

        public final String getAutomaticFailoverStatus() {
            return this.automaticFailoverStatus;
        }

        public final void setAutomaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
        }

        @Override
        public final Builder automaticFailoverStatus(String automaticFailoverStatus) {
            this.automaticFailoverStatus = automaticFailoverStatus;
            return this;
        }

        @Override
        public final Builder automaticFailoverStatus(PendingAutomaticFailoverStatus automaticFailoverStatus) {
            this.automaticFailoverStatus(automaticFailoverStatus == null ? null : automaticFailoverStatus.toString());
            return this;
        }

        public final ReshardingStatus.Builder getResharding() {
            return this.resharding != null ? this.resharding.toBuilder() : null;
        }

        public final void setResharding(ReshardingStatus.BuilderImpl resharding) {
            this.resharding = resharding != null ? resharding.build() : null;
        }

        @Override
        public final Builder resharding(ReshardingStatus resharding) {
            this.resharding = resharding;
            return this;
        }

        public final String getAuthTokenStatus() {
            return this.authTokenStatus;
        }

        public final void setAuthTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
        }

        @Override
        public final Builder authTokenStatus(String authTokenStatus) {
            this.authTokenStatus = authTokenStatus;
            return this;
        }

        @Override
        public final Builder authTokenStatus(AuthTokenUpdateStatus authTokenStatus) {
            this.authTokenStatus(authTokenStatus == null ? null : authTokenStatus.toString());
            return this;
        }

        public final UserGroupsUpdateStatus.Builder getUserGroups() {
            return this.userGroups != null ? this.userGroups.toBuilder() : null;
        }

        public final void setUserGroups(UserGroupsUpdateStatus.BuilderImpl userGroups) {
            this.userGroups = userGroups != null ? userGroups.build() : null;
        }

        @Override
        public final Builder userGroups(UserGroupsUpdateStatus userGroups) {
            this.userGroups = userGroups;
            return this;
        }

        public final List<PendingLogDeliveryConfiguration.Builder> getLogDeliveryConfigurations() {
            List<PendingLogDeliveryConfiguration.Builder> result = PendingLogDeliveryConfigurationListCopier.copyToBuilder(this.logDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration.BuilderImpl> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copyFromBuilder(logDeliveryConfigurations);
        }

        @Override
        public final Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> logDeliveryConfigurations) {
            this.logDeliveryConfigurations = PendingLogDeliveryConfigurationListCopier.copy(logDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Arrays.asList(logDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder> ... logDeliveryConfigurations) {
            this.logDeliveryConfigurations(Stream.of(logDeliveryConfigurations).map(c -> (PendingLogDeliveryConfiguration)((PendingLogDeliveryConfiguration.Builder)PendingLogDeliveryConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getTransitEncryptionEnabled() {
            return this.transitEncryptionEnabled;
        }

        public final void setTransitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
        }

        @Override
        public final Builder transitEncryptionEnabled(Boolean transitEncryptionEnabled) {
            this.transitEncryptionEnabled = transitEncryptionEnabled;
            return this;
        }

        public final String getTransitEncryptionMode() {
            return this.transitEncryptionMode;
        }

        public final void setTransitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
        }

        @Override
        public final Builder transitEncryptionMode(String transitEncryptionMode) {
            this.transitEncryptionMode = transitEncryptionMode;
            return this;
        }

        @Override
        public final Builder transitEncryptionMode(TransitEncryptionMode transitEncryptionMode) {
            this.transitEncryptionMode(transitEncryptionMode == null ? null : transitEncryptionMode.toString());
            return this;
        }

        public final String getClusterMode() {
            return this.clusterMode;
        }

        public final void setClusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
        }

        @Override
        public final Builder clusterMode(String clusterMode) {
            this.clusterMode = clusterMode;
            return this;
        }

        @Override
        public final Builder clusterMode(ClusterMode clusterMode) {
            this.clusterMode(clusterMode == null ? null : clusterMode.toString());
            return this;
        }

        public ReplicationGroupPendingModifiedValues build() {
            return new ReplicationGroupPendingModifiedValues(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplicationGroupPendingModifiedValues> {
        public Builder primaryClusterId(String var1);

        public Builder automaticFailoverStatus(String var1);

        public Builder automaticFailoverStatus(PendingAutomaticFailoverStatus var1);

        public Builder resharding(ReshardingStatus var1);

        default public Builder resharding(Consumer<ReshardingStatus.Builder> resharding) {
            return this.resharding((ReshardingStatus)((ReshardingStatus.Builder)ReshardingStatus.builder().applyMutation(resharding)).build());
        }

        public Builder authTokenStatus(String var1);

        public Builder authTokenStatus(AuthTokenUpdateStatus var1);

        public Builder userGroups(UserGroupsUpdateStatus var1);

        default public Builder userGroups(Consumer<UserGroupsUpdateStatus.Builder> userGroups) {
            return this.userGroups((UserGroupsUpdateStatus)((UserGroupsUpdateStatus.Builder)UserGroupsUpdateStatus.builder().applyMutation(userGroups)).build());
        }

        public Builder logDeliveryConfigurations(Collection<PendingLogDeliveryConfiguration> var1);

        public Builder logDeliveryConfigurations(PendingLogDeliveryConfiguration ... var1);

        public Builder logDeliveryConfigurations(Consumer<PendingLogDeliveryConfiguration.Builder> ... var1);

        public Builder transitEncryptionEnabled(Boolean var1);

        public Builder transitEncryptionMode(String var1);

        public Builder transitEncryptionMode(TransitEncryptionMode var1);

        public Builder clusterMode(String var1);

        public Builder clusterMode(ClusterMode var1);
    }
}

