/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the scanning configuration for a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RepositoryScanningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RepositoryScanningConfiguration.Builder, RepositoryScanningConfiguration> {
    private static final SdkField<String> REPOSITORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryArn").getter(getter(RepositoryScanningConfiguration::repositoryArn))
            .setter(setter(Builder::repositoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryArn").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(RepositoryScanningConfiguration::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<Boolean> SCAN_ON_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("scanOnPush").getter(getter(RepositoryScanningConfiguration::scanOnPush))
            .setter(setter(Builder::scanOnPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanOnPush").build()).build();

    private static final SdkField<String> SCAN_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scanFrequency").getter(getter(RepositoryScanningConfiguration::scanFrequencyAsString))
            .setter(setter(Builder::scanFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanFrequency").build()).build();

    private static final SdkField<List<ScanningRepositoryFilter>> APPLIED_SCAN_FILTERS_FIELD = SdkField
            .<List<ScanningRepositoryFilter>> builder(MarshallingType.LIST)
            .memberName("appliedScanFilters")
            .getter(getter(RepositoryScanningConfiguration::appliedScanFilters))
            .setter(setter(Builder::appliedScanFilters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedScanFilters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScanningRepositoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScanningRepositoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ARN_FIELD,
            REPOSITORY_NAME_FIELD, SCAN_ON_PUSH_FIELD, SCAN_FREQUENCY_FIELD, APPLIED_SCAN_FILTERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryArn;

    private final String repositoryName;

    private final Boolean scanOnPush;

    private final String scanFrequency;

    private final List<ScanningRepositoryFilter> appliedScanFilters;

    private RepositoryScanningConfiguration(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.repositoryName = builder.repositoryName;
        this.scanOnPush = builder.scanOnPush;
        this.scanFrequency = builder.scanFrequency;
        this.appliedScanFilters = builder.appliedScanFilters;
    }

    /**
     * <p>
     * The ARN of the repository.
     * </p>
     * 
     * @return The ARN of the repository.
     */
    public final String repositoryArn() {
        return repositoryArn;
    }

    /**
     * <p>
     * The name of the repository.
     * </p>
     * 
     * @return The name of the repository.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * Whether or not scan on push is configured for the repository.
     * </p>
     * 
     * @return Whether or not scan on push is configured for the repository.
     */
    public final Boolean scanOnPush() {
        return scanOnPush;
    }

    /**
     * <p>
     * The scan frequency for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link ScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The scan frequency for the repository.
     * @see ScanFrequency
     */
    public final ScanFrequency scanFrequency() {
        return ScanFrequency.fromValue(scanFrequency);
    }

    /**
     * <p>
     * The scan frequency for the repository.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanFrequency}
     * will return {@link ScanFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanFrequencyAsString}.
     * </p>
     * 
     * @return The scan frequency for the repository.
     * @see ScanFrequency
     */
    public final String scanFrequencyAsString() {
        return scanFrequency;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppliedScanFilters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAppliedScanFilters() {
        return appliedScanFilters != null && !(appliedScanFilters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The scan filters applied to the repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppliedScanFilters} method.
     * </p>
     * 
     * @return The scan filters applied to the repository.
     */
    public final List<ScanningRepositoryFilter> appliedScanFilters() {
        return appliedScanFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(scanOnPush());
        hashCode = 31 * hashCode + Objects.hashCode(scanFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppliedScanFilters() ? appliedScanFilters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryScanningConfiguration)) {
            return false;
        }
        RepositoryScanningConfiguration other = (RepositoryScanningConfiguration) obj;
        return Objects.equals(repositoryArn(), other.repositoryArn()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(scanOnPush(), other.scanOnPush())
                && Objects.equals(scanFrequencyAsString(), other.scanFrequencyAsString())
                && hasAppliedScanFilters() == other.hasAppliedScanFilters()
                && Objects.equals(appliedScanFilters(), other.appliedScanFilters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RepositoryScanningConfiguration").add("RepositoryArn", repositoryArn())
                .add("RepositoryName", repositoryName()).add("ScanOnPush", scanOnPush())
                .add("ScanFrequency", scanFrequencyAsString())
                .add("AppliedScanFilters", hasAppliedScanFilters() ? appliedScanFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryArn":
            return Optional.ofNullable(clazz.cast(repositoryArn()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "scanOnPush":
            return Optional.ofNullable(clazz.cast(scanOnPush()));
        case "scanFrequency":
            return Optional.ofNullable(clazz.cast(scanFrequencyAsString()));
        case "appliedScanFilters":
            return Optional.ofNullable(clazz.cast(appliedScanFilters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryScanningConfiguration, T> g) {
        return obj -> g.apply((RepositoryScanningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RepositoryScanningConfiguration> {
        /**
         * <p>
         * The ARN of the repository.
         * </p>
         * 
         * @param repositoryArn
         *        The ARN of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryArn(String repositoryArn);

        /**
         * <p>
         * The name of the repository.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * Whether or not scan on push is configured for the repository.
         * </p>
         * 
         * @param scanOnPush
         *        Whether or not scan on push is configured for the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanOnPush(Boolean scanOnPush);

        /**
         * <p>
         * The scan frequency for the repository.
         * </p>
         * 
         * @param scanFrequency
         *        The scan frequency for the repository.
         * @see ScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanFrequency
         */
        Builder scanFrequency(String scanFrequency);

        /**
         * <p>
         * The scan frequency for the repository.
         * </p>
         * 
         * @param scanFrequency
         *        The scan frequency for the repository.
         * @see ScanFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanFrequency
         */
        Builder scanFrequency(ScanFrequency scanFrequency);

        /**
         * <p>
         * The scan filters applied to the repository.
         * </p>
         * 
         * @param appliedScanFilters
         *        The scan filters applied to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedScanFilters(Collection<ScanningRepositoryFilter> appliedScanFilters);

        /**
         * <p>
         * The scan filters applied to the repository.
         * </p>
         * 
         * @param appliedScanFilters
         *        The scan filters applied to the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedScanFilters(ScanningRepositoryFilter... appliedScanFilters);

        /**
         * <p>
         * The scan filters applied to the repository.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #appliedScanFilters(List<ScanningRepositoryFilter>)}.
         * 
         * @param appliedScanFilters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.ScanningRepositoryFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedScanFilters(java.util.Collection<ScanningRepositoryFilter>)
         */
        Builder appliedScanFilters(Consumer<ScanningRepositoryFilter.Builder>... appliedScanFilters);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryArn;

        private String repositoryName;

        private Boolean scanOnPush;

        private String scanFrequency;

        private List<ScanningRepositoryFilter> appliedScanFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryScanningConfiguration model) {
            repositoryArn(model.repositoryArn);
            repositoryName(model.repositoryName);
            scanOnPush(model.scanOnPush);
            scanFrequency(model.scanFrequency);
            appliedScanFilters(model.appliedScanFilters);
        }

        public final String getRepositoryArn() {
            return repositoryArn;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final Boolean getScanOnPush() {
            return scanOnPush;
        }

        public final void setScanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
        }

        @Override
        public final Builder scanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
            return this;
        }

        public final String getScanFrequency() {
            return scanFrequency;
        }

        public final void setScanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
        }

        @Override
        public final Builder scanFrequency(String scanFrequency) {
            this.scanFrequency = scanFrequency;
            return this;
        }

        @Override
        public final Builder scanFrequency(ScanFrequency scanFrequency) {
            this.scanFrequency(scanFrequency == null ? null : scanFrequency.toString());
            return this;
        }

        public final List<ScanningRepositoryFilter.Builder> getAppliedScanFilters() {
            List<ScanningRepositoryFilter.Builder> result = ScanningRepositoryFilterListCopier
                    .copyToBuilder(this.appliedScanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedScanFilters(Collection<ScanningRepositoryFilter.BuilderImpl> appliedScanFilters) {
            this.appliedScanFilters = ScanningRepositoryFilterListCopier.copyFromBuilder(appliedScanFilters);
        }

        @Override
        public final Builder appliedScanFilters(Collection<ScanningRepositoryFilter> appliedScanFilters) {
            this.appliedScanFilters = ScanningRepositoryFilterListCopier.copy(appliedScanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedScanFilters(ScanningRepositoryFilter... appliedScanFilters) {
            appliedScanFilters(Arrays.asList(appliedScanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedScanFilters(Consumer<ScanningRepositoryFilter.Builder>... appliedScanFilters) {
            appliedScanFilters(Stream.of(appliedScanFilters)
                    .map(c -> ScanningRepositoryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RepositoryScanningConfiguration build() {
            return new RepositoryScanningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
