/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyVerifiedAccessEndpointRequest extends Ec2Request implements
        ToCopyableBuilder<ModifyVerifiedAccessEndpointRequest.Builder, ModifyVerifiedAccessEndpointRequest> {
    private static final SdkField<String> VERIFIED_ACCESS_ENDPOINT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessEndpointId")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::verifiedAccessEndpointId))
            .setter(setter(Builder::verifiedAccessEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessEndpointId")
                    .unmarshallLocationName("VerifiedAccessEndpointId").build()).build();

    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("VerifiedAccessGroupId")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::verifiedAccessGroupId))
            .setter(setter(Builder::verifiedAccessGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId")
                    .unmarshallLocationName("VerifiedAccessGroupId").build()).build();

    private static final SdkField<ModifyVerifiedAccessEndpointLoadBalancerOptions> LOAD_BALANCER_OPTIONS_FIELD = SdkField
            .<ModifyVerifiedAccessEndpointLoadBalancerOptions> builder(MarshallingType.SDK_POJO)
            .memberName("LoadBalancerOptions")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::loadBalancerOptions))
            .setter(setter(Builder::loadBalancerOptions))
            .constructor(ModifyVerifiedAccessEndpointLoadBalancerOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerOptions")
                    .unmarshallLocationName("LoadBalancerOptions").build()).build();

    private static final SdkField<ModifyVerifiedAccessEndpointEniOptions> NETWORK_INTERFACE_OPTIONS_FIELD = SdkField
            .<ModifyVerifiedAccessEndpointEniOptions> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInterfaceOptions")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::networkInterfaceOptions))
            .setter(setter(Builder::networkInterfaceOptions))
            .constructor(ModifyVerifiedAccessEndpointEniOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOptions")
                    .unmarshallLocationName("NetworkInterfaceOptions").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ModifyVerifiedAccessEndpointRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken")
                    .unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VERIFIED_ACCESS_ENDPOINT_ID_FIELD, VERIFIED_ACCESS_GROUP_ID_FIELD, LOAD_BALANCER_OPTIONS_FIELD,
            NETWORK_INTERFACE_OPTIONS_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));

    private final String verifiedAccessEndpointId;

    private final String verifiedAccessGroupId;

    private final ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;

    private final ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;

    private final String description;

    private final String clientToken;

    private ModifyVerifiedAccessEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessEndpointId = builder.verifiedAccessEndpointId;
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.loadBalancerOptions = builder.loadBalancerOptions;
        this.networkInterfaceOptions = builder.networkInterfaceOptions;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access endpoint.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access endpoint.
     */
    public final String verifiedAccessEndpointId() {
        return verifiedAccessEndpointId;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Verified Access group.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Verified Access group.
     */
    public final String verifiedAccessGroupId() {
        return verifiedAccessGroupId;
    }

    /**
     * <p>
     * The load balancer details if creating the Amazon Web Services Verified Access endpoint as
     * <code>load-balancer</code>type.
     * </p>
     * 
     * @return The load balancer details if creating the Amazon Web Services Verified Access endpoint as
     *         <code>load-balancer</code>type.
     */
    public final ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions() {
        return loadBalancerOptions;
    }

    /**
     * <p>
     * The network interface options.
     * </p>
     * 
     * @return The network interface options.
     */
    public final ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions() {
        return networkInterfaceOptions;
    }

    /**
     * <p>
     * A description for the Amazon Web Services Verified Access endpoint.
     * </p>
     * 
     * @return A description for the Amazon Web Services Verified Access endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * Idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         Idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVerifiedAccessEndpointRequest)) {
            return false;
        }
        ModifyVerifiedAccessEndpointRequest other = (ModifyVerifiedAccessEndpointRequest) obj;
        return Objects.equals(verifiedAccessEndpointId(), other.verifiedAccessEndpointId())
                && Objects.equals(verifiedAccessGroupId(), other.verifiedAccessGroupId())
                && Objects.equals(loadBalancerOptions(), other.loadBalancerOptions())
                && Objects.equals(networkInterfaceOptions(), other.networkInterfaceOptions())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyVerifiedAccessEndpointRequest")
                .add("VerifiedAccessEndpointId", verifiedAccessEndpointId())
                .add("VerifiedAccessGroupId", verifiedAccessGroupId()).add("LoadBalancerOptions", loadBalancerOptions())
                .add("NetworkInterfaceOptions", networkInterfaceOptions()).add("Description", description())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VerifiedAccessEndpointId":
            return Optional.ofNullable(clazz.cast(verifiedAccessEndpointId()));
        case "VerifiedAccessGroupId":
            return Optional.ofNullable(clazz.cast(verifiedAccessGroupId()));
        case "LoadBalancerOptions":
            return Optional.ofNullable(clazz.cast(loadBalancerOptions()));
        case "NetworkInterfaceOptions":
            return Optional.ofNullable(clazz.cast(networkInterfaceOptions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVerifiedAccessEndpointRequest, T> g) {
        return obj -> g.apply((ModifyVerifiedAccessEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, ModifyVerifiedAccessEndpointRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access endpoint.
         * </p>
         * 
         * @param verifiedAccessEndpointId
         *        The ID of the Amazon Web Services Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessEndpointId(String verifiedAccessEndpointId);

        /**
         * <p>
         * The ID of the Amazon Web Services Verified Access group.
         * </p>
         * 
         * @param verifiedAccessGroupId
         *        The ID of the Amazon Web Services Verified Access group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder verifiedAccessGroupId(String verifiedAccessGroupId);

        /**
         * <p>
         * The load balancer details if creating the Amazon Web Services Verified Access endpoint as
         * <code>load-balancer</code>type.
         * </p>
         * 
         * @param loadBalancerOptions
         *        The load balancer details if creating the Amazon Web Services Verified Access endpoint as
         *        <code>load-balancer</code>type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions);

        /**
         * <p>
         * The load balancer details if creating the Amazon Web Services Verified Access endpoint as
         * <code>load-balancer</code>type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder} avoiding the need to create one manually via
         * {@link ModifyVerifiedAccessEndpointLoadBalancerOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions)}.
         * 
         * @param loadBalancerOptions
         *        a consumer that will call methods on {@link ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions)
         */
        default Builder loadBalancerOptions(Consumer<ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder> loadBalancerOptions) {
            return loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions.builder()
                    .applyMutation(loadBalancerOptions).build());
        }

        /**
         * <p>
         * The network interface options.
         * </p>
         * 
         * @param networkInterfaceOptions
         *        The network interface options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions);

        /**
         * <p>
         * The network interface options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModifyVerifiedAccessEndpointEniOptions.Builder} avoiding the need to create one manually via
         * {@link ModifyVerifiedAccessEndpointEniOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModifyVerifiedAccessEndpointEniOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions)}.
         * 
         * @param networkInterfaceOptions
         *        a consumer that will call methods on {@link ModifyVerifiedAccessEndpointEniOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions)
         */
        default Builder networkInterfaceOptions(Consumer<ModifyVerifiedAccessEndpointEniOptions.Builder> networkInterfaceOptions) {
            return networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions.builder()
                    .applyMutation(networkInterfaceOptions).build());
        }

        /**
         * <p>
         * A description for the Amazon Web Services Verified Access endpoint.
         * </p>
         * 
         * @param description
         *        A description for the Amazon Web Services Verified Access endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure idempotency of your modification request. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * Idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure idempotency of your modification request.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        Idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private String verifiedAccessEndpointId;

        private String verifiedAccessGroupId;

        private ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions;

        private ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions;

        private String description;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVerifiedAccessEndpointRequest model) {
            super(model);
            verifiedAccessEndpointId(model.verifiedAccessEndpointId);
            verifiedAccessGroupId(model.verifiedAccessGroupId);
            loadBalancerOptions(model.loadBalancerOptions);
            networkInterfaceOptions(model.networkInterfaceOptions);
            description(model.description);
            clientToken(model.clientToken);
        }

        public final String getVerifiedAccessEndpointId() {
            return verifiedAccessEndpointId;
        }

        public final void setVerifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
        }

        @Override
        public final Builder verifiedAccessEndpointId(String verifiedAccessEndpointId) {
            this.verifiedAccessEndpointId = verifiedAccessEndpointId;
            return this;
        }

        public final String getVerifiedAccessGroupId() {
            return verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final ModifyVerifiedAccessEndpointLoadBalancerOptions.Builder getLoadBalancerOptions() {
            return loadBalancerOptions != null ? loadBalancerOptions.toBuilder() : null;
        }

        public final void setLoadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions.BuilderImpl loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions != null ? loadBalancerOptions.build() : null;
        }

        @Override
        public final Builder loadBalancerOptions(ModifyVerifiedAccessEndpointLoadBalancerOptions loadBalancerOptions) {
            this.loadBalancerOptions = loadBalancerOptions;
            return this;
        }

        public final ModifyVerifiedAccessEndpointEniOptions.Builder getNetworkInterfaceOptions() {
            return networkInterfaceOptions != null ? networkInterfaceOptions.toBuilder() : null;
        }

        public final void setNetworkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions.BuilderImpl networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions != null ? networkInterfaceOptions.build() : null;
        }

        @Override
        public final Builder networkInterfaceOptions(ModifyVerifiedAccessEndpointEniOptions networkInterfaceOptions) {
            this.networkInterfaceOptions = networkInterfaceOptions;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVerifiedAccessEndpointRequest build() {
            return new ModifyVerifiedAccessEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
