/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImageBlockPublicAccessStateResponse extends Ec2Response implements
        ToCopyableBuilder<GetImageBlockPublicAccessStateResponse.Builder, GetImageBlockPublicAccessStateResponse> {
    private static final SdkField<String> IMAGE_BLOCK_PUBLIC_ACCESS_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ImageBlockPublicAccessState")
            .getter(getter(GetImageBlockPublicAccessStateResponse::imageBlockPublicAccessState))
            .setter(setter(Builder::imageBlockPublicAccessState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageBlockPublicAccessState")
                    .unmarshallLocationName("imageBlockPublicAccessState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGE_BLOCK_PUBLIC_ACCESS_STATE_FIELD));

    private final String imageBlockPublicAccessState;

    private GetImageBlockPublicAccessStateResponse(BuilderImpl builder) {
        super(builder);
        this.imageBlockPublicAccessState = builder.imageBlockPublicAccessState;
    }

    /**
     * <p>
     * The current state of block public access for AMIs at the account level in the specified Amazon Web Services
     * Region.
     * </p>
     * <p>
     * Possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>block-new-sharing</code> - Any attempt to publicly share your AMIs in the specified Region is blocked.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>unblocked</code> - Your AMIs in the specified Region can be publicly shared.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The current state of block public access for AMIs at the account level in the specified Amazon Web
     *         Services Region.</p>
     *         <p>
     *         Possible values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>block-new-sharing</code> - Any attempt to publicly share your AMIs in the specified Region is
     *         blocked.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>unblocked</code> - Your AMIs in the specified Region can be publicly shared.
     *         </p>
     *         </li>
     */
    public final String imageBlockPublicAccessState() {
        return imageBlockPublicAccessState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(imageBlockPublicAccessState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImageBlockPublicAccessStateResponse)) {
            return false;
        }
        GetImageBlockPublicAccessStateResponse other = (GetImageBlockPublicAccessStateResponse) obj;
        return Objects.equals(imageBlockPublicAccessState(), other.imageBlockPublicAccessState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImageBlockPublicAccessStateResponse")
                .add("ImageBlockPublicAccessState", imageBlockPublicAccessState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImageBlockPublicAccessState":
            return Optional.ofNullable(clazz.cast(imageBlockPublicAccessState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImageBlockPublicAccessStateResponse, T> g) {
        return obj -> g.apply((GetImageBlockPublicAccessStateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetImageBlockPublicAccessStateResponse> {
        /**
         * <p>
         * The current state of block public access for AMIs at the account level in the specified Amazon Web Services
         * Region.
         * </p>
         * <p>
         * Possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>block-new-sharing</code> - Any attempt to publicly share your AMIs in the specified Region is blocked.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>unblocked</code> - Your AMIs in the specified Region can be publicly shared.
         * </p>
         * </li>
         * </ul>
         * 
         * @param imageBlockPublicAccessState
         *        The current state of block public access for AMIs at the account level in the specified Amazon Web
         *        Services Region.</p>
         *        <p>
         *        Possible values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>block-new-sharing</code> - Any attempt to publicly share your AMIs in the specified Region is
         *        blocked.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>unblocked</code> - Your AMIs in the specified Region can be publicly shared.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBlockPublicAccessState(String imageBlockPublicAccessState);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String imageBlockPublicAccessState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImageBlockPublicAccessStateResponse model) {
            super(model);
            imageBlockPublicAccessState(model.imageBlockPublicAccessState);
        }

        public final String getImageBlockPublicAccessState() {
            return imageBlockPublicAccessState;
        }

        public final void setImageBlockPublicAccessState(String imageBlockPublicAccessState) {
            this.imageBlockPublicAccessState = imageBlockPublicAccessState;
        }

        @Override
        public final Builder imageBlockPublicAccessState(String imageBlockPublicAccessState) {
            this.imageBlockPublicAccessState = imageBlockPublicAccessState;
            return this;
        }

        @Override
        public GetImageBlockPublicAccessStateResponse build() {
            return new GetImageBlockPublicAccessStateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
