/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.TableNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTablesResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, ListTablesResponse> {
    private static final SdkField<List<String>> TABLE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableNames").getter(ListTablesResponse.getter(ListTablesResponse::tableNames)).setter(ListTablesResponse.setter(Builder::tableNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_EVALUATED_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastEvaluatedTableName").getter(ListTablesResponse.getter(ListTablesResponse::lastEvaluatedTableName)).setter(ListTablesResponse.setter(Builder::lastEvaluatedTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastEvaluatedTableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAMES_FIELD, LAST_EVALUATED_TABLE_NAME_FIELD));
    private final List<String> tableNames;
    private final String lastEvaluatedTableName;

    private ListTablesResponse(BuilderImpl builder) {
        super(builder);
        this.tableNames = builder.tableNames;
        this.lastEvaluatedTableName = builder.lastEvaluatedTableName;
    }

    public final boolean hasTableNames() {
        return this.tableNames != null && !(this.tableNames instanceof SdkAutoConstructList);
    }

    public final List<String> tableNames() {
        return this.tableNames;
    }

    public final String lastEvaluatedTableName() {
        return this.lastEvaluatedTableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableNames() ? this.tableNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedTableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesResponse)) {
            return false;
        }
        ListTablesResponse other = (ListTablesResponse)((Object)obj);
        return this.hasTableNames() == other.hasTableNames() && Objects.equals(this.tableNames(), other.tableNames()) && Objects.equals(this.lastEvaluatedTableName(), other.lastEvaluatedTableName());
    }

    public final String toString() {
        return ToString.builder((String)"ListTablesResponse").add("TableNames", this.hasTableNames() ? this.tableNames() : null).add("LastEvaluatedTableName", (Object)this.lastEvaluatedTableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableNames": {
                return Optional.ofNullable(clazz.cast(this.tableNames()));
            }
            case "LastEvaluatedTableName": {
                return Optional.ofNullable(clazz.cast(this.lastEvaluatedTableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesResponse, T> g) {
        return obj -> g.apply((ListTablesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<String> tableNames = DefaultSdkAutoConstructList.getInstance();
        private String lastEvaluatedTableName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesResponse model) {
            super(model);
            this.tableNames(model.tableNames);
            this.lastEvaluatedTableName(model.lastEvaluatedTableName);
        }

        public final Collection<String> getTableNames() {
            if (this.tableNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tableNames;
        }

        public final void setTableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
        }

        @Override
        public final Builder tableNames(Collection<String> tableNames) {
            this.tableNames = TableNameListCopier.copy(tableNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableNames(String ... tableNames) {
            this.tableNames(Arrays.asList(tableNames));
            return this;
        }

        public final String getLastEvaluatedTableName() {
            return this.lastEvaluatedTableName;
        }

        public final void setLastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
        }

        @Override
        public final Builder lastEvaluatedTableName(String lastEvaluatedTableName) {
            this.lastEvaluatedTableName = lastEvaluatedTableName;
            return this;
        }

        @Override
        public ListTablesResponse build() {
            return new ListTablesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTablesResponse> {
        public Builder tableNames(Collection<String> var1);

        public Builder tableNames(String ... var1);

        public Builder lastEvaluatedTableName(String var1);
    }
}

