/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.model;

import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;

@SdkPublicApi
@ThreadSafe
public final class GetItemEnhancedRequest {
    private final Key key;
    private final Boolean consistentRead;
    private final String returnConsumedCapacity;

    private GetItemEnhancedRequest(Builder builder) {
        this.key = builder.key;
        this.consistentRead = builder.consistentRead;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GetItemEnhancedRequest.builder().key(this.key).consistentRead(this.consistentRead).returnConsumedCapacity(this.returnConsumedCapacity);
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public Key key() {
        return this.key;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue((String)this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetItemEnhancedRequest that = (GetItemEnhancedRequest)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.consistentRead, that.consistentRead) && Objects.equals(this.returnConsumedCapacity, that.returnConsumedCapacity);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.consistentRead != null ? this.consistentRead.hashCode() : 0);
        result = 31 * result + (this.returnConsumedCapacity != null ? this.returnConsumedCapacity.hashCode() : 0);
        return result;
    }

    @NotThreadSafe
    public static final class Builder {
        private Key key;
        private Boolean consistentRead;
        private String returnConsumedCapacity;

        private Builder() {
        }

        public Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public Builder key(Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Consumer<Key.Builder> keyConsumer) {
            Key.Builder builder = Key.builder();
            keyConsumer.accept(builder);
            return this.key(builder.build());
        }

        public Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity == null ? null : returnConsumedCapacity.toString();
            return this;
        }

        public Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public GetItemEnhancedRequest build() {
            return new GetItemEnhancedRequest(this);
        }
    }
}

