/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum RecoveryInstanceDataReplicationInitiationStepName {
    LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE("LINK_FAILBACK_CLIENT_WITH_RECOVERY_INSTANCE"),

    COMPLETE_VOLUME_MAPPING("COMPLETE_VOLUME_MAPPING"),

    ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION("ESTABLISH_RECOVERY_INSTANCE_COMMUNICATION"),

    DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT("DOWNLOAD_REPLICATION_SOFTWARE_TO_FAILBACK_CLIENT"),

    CONFIGURE_REPLICATION_SOFTWARE("CONFIGURE_REPLICATION_SOFTWARE"),

    PAIR_AGENT_WITH_REPLICATION_SOFTWARE("PAIR_AGENT_WITH_REPLICATION_SOFTWARE"),

    ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION("ESTABLISH_AGENT_REPLICATOR_SOFTWARE_COMMUNICATION"),

    WAIT("WAIT"),

    CREATE_SECURITY_GROUP("CREATE_SECURITY_GROUP"),

    LAUNCH_REPLICATION_SERVER("LAUNCH_REPLICATION_SERVER"),

    BOOT_REPLICATION_SERVER("BOOT_REPLICATION_SERVER"),

    AUTHENTICATE_WITH_SERVICE("AUTHENTICATE_WITH_SERVICE"),

    DOWNLOAD_REPLICATION_SOFTWARE("DOWNLOAD_REPLICATION_SOFTWARE"),

    CREATE_STAGING_DISKS("CREATE_STAGING_DISKS"),

    ATTACH_STAGING_DISKS("ATTACH_STAGING_DISKS"),

    PAIR_REPLICATION_SERVER_WITH_AGENT("PAIR_REPLICATION_SERVER_WITH_AGENT"),

    CONNECT_AGENT_TO_REPLICATION_SERVER("CONNECT_AGENT_TO_REPLICATION_SERVER"),

    START_DATA_TRANSFER("START_DATA_TRANSFER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecoveryInstanceDataReplicationInitiationStepName> VALUE_MAP = EnumUtils.uniqueIndex(
            RecoveryInstanceDataReplicationInitiationStepName.class, RecoveryInstanceDataReplicationInitiationStepName::toString);

    private final String value;

    private RecoveryInstanceDataReplicationInitiationStepName(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return RecoveryInstanceDataReplicationInitiationStepName corresponding to the value
     */
    public static RecoveryInstanceDataReplicationInitiationStepName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link RecoveryInstanceDataReplicationInitiationStepName}s
     */
    public static Set<RecoveryInstanceDataReplicationInitiationStepName> knownValues() {
        Set<RecoveryInstanceDataReplicationInitiationStepName> knownValues = EnumSet
                .allOf(RecoveryInstanceDataReplicationInitiationStepName.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
