/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdbelastic.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSnapshotInList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSnapshotInList> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(ClusterSnapshotInList.getter(ClusterSnapshotInList::clusterArn)).setter(ClusterSnapshotInList.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(ClusterSnapshotInList.getter(ClusterSnapshotInList::snapshotArn)).setter(ClusterSnapshotInList.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotCreationTime").getter(ClusterSnapshotInList.getter(ClusterSnapshotInList::snapshotCreationTime)).setter(ClusterSnapshotInList.setter(Builder::snapshotCreationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreationTime").build()}).build();
    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotName").getter(ClusterSnapshotInList.getter(ClusterSnapshotInList::snapshotName)).setter(ClusterSnapshotInList.setter(Builder::snapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ClusterSnapshotInList.getter(ClusterSnapshotInList::statusAsString)).setter(ClusterSnapshotInList.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATION_TIME_FIELD, SNAPSHOT_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String snapshotArn;
    private final String snapshotCreationTime;
    private final String snapshotName;
    private final String status;

    private ClusterSnapshotInList(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreationTime = builder.snapshotCreationTime;
        this.snapshotName = builder.snapshotName;
        this.status = builder.status;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotCreationTime() {
        return this.snapshotCreationTime;
    }

    public final String snapshotName() {
        return this.snapshotName;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCreationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotInList)) {
            return false;
        }
        ClusterSnapshotInList other = (ClusterSnapshotInList)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotCreationTime(), other.snapshotCreationTime()) && Objects.equals(this.snapshotName(), other.snapshotName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSnapshotInList").add("ClusterArn", (Object)this.clusterArn()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotCreationTime", (Object)this.snapshotCreationTime()).add("SnapshotName", (Object)this.snapshotName()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "snapshotCreationTime": {
                return Optional.ofNullable(clazz.cast(this.snapshotCreationTime()));
            }
            case "snapshotName": {
                return Optional.ofNullable(clazz.cast(this.snapshotName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshotInList, T> g) {
        return obj -> g.apply((ClusterSnapshotInList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String snapshotArn;
        private String snapshotCreationTime;
        private String snapshotName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotInList model) {
            this.clusterArn(model.clusterArn);
            this.snapshotArn(model.snapshotArn);
            this.snapshotCreationTime(model.snapshotCreationTime);
            this.snapshotName(model.snapshotName);
            this.status(model.status);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotCreationTime() {
            return this.snapshotCreationTime;
        }

        public final void setSnapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
        }

        @Override
        public final Builder snapshotCreationTime(String snapshotCreationTime) {
            this.snapshotCreationTime = snapshotCreationTime;
            return this;
        }

        public final String getSnapshotName() {
            return this.snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ClusterSnapshotInList build() {
            return new ClusterSnapshotInList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSnapshotInList> {
        public Builder clusterArn(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotCreationTime(String var1);

        public Builder snapshotName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

