/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains general information about a certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CertificateInfo implements SdkPojo, Serializable, ToCopyableBuilder<CertificateInfo.Builder, CertificateInfo> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(CertificateInfo::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommonName").getter(getter(CertificateInfo::commonName)).setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(CertificateInfo::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryDateTime").getter(getter(CertificateInfo::expiryDateTime)).setter(setter(Builder::expiryDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CertificateInfo::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            COMMON_NAME_FIELD, STATE_FIELD, EXPIRY_DATE_TIME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateId;

    private final String commonName;

    private final String state;

    private final Instant expiryDateTime;

    private final String type;

    private CertificateInfo(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.commonName = builder.commonName;
        this.state = builder.state;
        this.expiryDateTime = builder.expiryDateTime;
        this.type = builder.type;
    }

    /**
     * <p>
     * The identifier of the certificate.
     * </p>
     * 
     * @return The identifier of the certificate.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The common name for the certificate.
     * </p>
     * 
     * @return The common name for the certificate.
     */
    public final String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public final CertificateState state() {
        return CertificateState.fromValue(state);
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when the certificate will expire.
     * </p>
     * 
     * @return The date and time when the certificate will expire.
     */
    public final Instant expiryDateTime() {
        return expiryDateTime;
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(expiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateInfo)) {
            return false;
        }
        CertificateInfo other = (CertificateInfo) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(commonName(), other.commonName())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(expiryDateTime(), other.expiryDateTime())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CertificateInfo").add("CertificateId", certificateId()).add("CommonName", commonName())
                .add("State", stateAsString()).add("ExpiryDateTime", expiryDateTime()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ExpiryDateTime":
            return Optional.ofNullable(clazz.cast(expiryDateTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateInfo, T> g) {
        return obj -> g.apply((CertificateInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CertificateInfo> {
        /**
         * <p>
         * The identifier of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The identifier of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The common name for the certificate.
         * </p>
         * 
         * @param commonName
         *        The common name for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(CertificateState state);

        /**
         * <p>
         * The date and time when the certificate will expire.
         * </p>
         * 
         * @param expiryDateTime
         *        The date and time when the certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryDateTime(Instant expiryDateTime);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);
    }

    static final class BuilderImpl implements Builder {
        private String certificateId;

        private String commonName;

        private String state;

        private Instant expiryDateTime;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateInfo model) {
            certificateId(model.certificateId);
            commonName(model.commonName);
            state(model.state);
            expiryDateTime(model.expiryDateTime);
            type(model.type);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCommonName() {
            return commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getExpiryDateTime() {
            return expiryDateTime;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public CertificateInfo build() {
            return new CertificateInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
