/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the resource that is being monitored, including the name of the resource, the type of resource, and
 * whether or not permission is given to DevOps Guru to access that resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonitoredResourceIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<MonitoredResourceIdentifier.Builder, MonitoredResourceIdentifier> {
    private static final SdkField<String> MONITORED_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoredResourceName").getter(getter(MonitoredResourceIdentifier::monitoredResourceName))
            .setter(setter(Builder::monitoredResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoredResourceName").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(MonitoredResourceIdentifier::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> RESOURCE_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePermission").getter(getter(MonitoredResourceIdentifier::resourcePermissionAsString))
            .setter(setter(Builder::resourcePermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePermission").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(MonitoredResourceIdentifier::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(MonitoredResourceIdentifier::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORED_RESOURCE_NAME_FIELD,
            TYPE_FIELD, RESOURCE_PERMISSION_FIELD, LAST_UPDATED_FIELD, RESOURCE_COLLECTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String monitoredResourceName;

    private final String type;

    private final String resourcePermission;

    private final Instant lastUpdated;

    private final ResourceCollection resourceCollection;

    private MonitoredResourceIdentifier(BuilderImpl builder) {
        this.monitoredResourceName = builder.monitoredResourceName;
        this.type = builder.type;
        this.resourcePermission = builder.resourcePermission;
        this.lastUpdated = builder.lastUpdated;
        this.resourceCollection = builder.resourceCollection;
    }

    /**
     * <p>
     * The name of the resource being monitored.
     * </p>
     * 
     * @return The name of the resource being monitored.
     */
    public final String monitoredResourceName() {
        return monitoredResourceName;
    }

    /**
     * <p>
     * The type of resource being monitored.
     * </p>
     * 
     * @return The type of resource being monitored.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The permission status of a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourcePermission} will return {@link ResourcePermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resourcePermissionAsString}.
     * </p>
     * 
     * @return The permission status of a resource.
     * @see ResourcePermission
     */
    public final ResourcePermission resourcePermission() {
        return ResourcePermission.fromValue(resourcePermission);
    }

    /**
     * <p>
     * The permission status of a resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourcePermission} will return {@link ResourcePermission#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #resourcePermissionAsString}.
     * </p>
     * 
     * @return The permission status of a resource.
     * @see ResourcePermission
     */
    public final String resourcePermissionAsString() {
        return resourcePermission;
    }

    /**
     * <p>
     * The time at which DevOps Guru last updated this resource.
     * </p>
     * 
     * @return The time at which DevOps Guru last updated this resource.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(monitoredResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoredResourceIdentifier)) {
            return false;
        }
        MonitoredResourceIdentifier other = (MonitoredResourceIdentifier) obj;
        return Objects.equals(monitoredResourceName(), other.monitoredResourceName()) && Objects.equals(type(), other.type())
                && Objects.equals(resourcePermissionAsString(), other.resourcePermissionAsString())
                && Objects.equals(lastUpdated(), other.lastUpdated())
                && Objects.equals(resourceCollection(), other.resourceCollection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonitoredResourceIdentifier").add("MonitoredResourceName", monitoredResourceName())
                .add("Type", type()).add("ResourcePermission", resourcePermissionAsString()).add("LastUpdated", lastUpdated())
                .add("ResourceCollection", resourceCollection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoredResourceName":
            return Optional.ofNullable(clazz.cast(monitoredResourceName()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ResourcePermission":
            return Optional.ofNullable(clazz.cast(resourcePermissionAsString()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoredResourceIdentifier, T> g) {
        return obj -> g.apply((MonitoredResourceIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonitoredResourceIdentifier> {
        /**
         * <p>
         * The name of the resource being monitored.
         * </p>
         * 
         * @param monitoredResourceName
         *        The name of the resource being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoredResourceName(String monitoredResourceName);

        /**
         * <p>
         * The type of resource being monitored.
         * </p>
         * 
         * @param type
         *        The type of resource being monitored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The permission status of a resource.
         * </p>
         * 
         * @param resourcePermission
         *        The permission status of a resource.
         * @see ResourcePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcePermission
         */
        Builder resourcePermission(String resourcePermission);

        /**
         * <p>
         * The permission status of a resource.
         * </p>
         * 
         * @param resourcePermission
         *        The permission status of a resource.
         * @see ResourcePermission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourcePermission
         */
        Builder resourcePermission(ResourcePermission resourcePermission);

        /**
         * <p>
         * The time at which DevOps Guru last updated this resource.
         * </p>
         * 
         * @param lastUpdated
         *        The time at which DevOps Guru last updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String monitoredResourceName;

        private String type;

        private String resourcePermission;

        private Instant lastUpdated;

        private ResourceCollection resourceCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoredResourceIdentifier model) {
            monitoredResourceName(model.monitoredResourceName);
            type(model.type);
            resourcePermission(model.resourcePermission);
            lastUpdated(model.lastUpdated);
            resourceCollection(model.resourceCollection);
        }

        public final String getMonitoredResourceName() {
            return monitoredResourceName;
        }

        public final void setMonitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
        }

        @Override
        public final Builder monitoredResourceName(String monitoredResourceName) {
            this.monitoredResourceName = monitoredResourceName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getResourcePermission() {
            return resourcePermission;
        }

        public final void setResourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
        }

        @Override
        public final Builder resourcePermission(String resourcePermission) {
            this.resourcePermission = resourcePermission;
            return this;
        }

        @Override
        public final Builder resourcePermission(ResourcePermission resourcePermission) {
            this.resourcePermission(resourcePermission == null ? null : resourcePermission.toString());
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        @Override
        public MonitoredResourceIdentifier build() {
            return new MonitoredResourceIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
