/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.devicefarm.DeviceFarmAsyncClient;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsRequest;
import software.amazon.awssdk.services.devicefarm.model.ListTestGridSessionActionsResponse;

public class ListTestGridSessionActionsPublisher
implements SdkPublisher<ListTestGridSessionActionsResponse> {
    private final DeviceFarmAsyncClient client;
    private final ListTestGridSessionActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestGridSessionActionsPublisher(DeviceFarmAsyncClient client, ListTestGridSessionActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestGridSessionActionsPublisher(DeviceFarmAsyncClient client, ListTestGridSessionActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestGridSessionActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestGridSessionActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTestGridSessionActionsResponseFetcher
    implements AsyncPageFetcher<ListTestGridSessionActionsResponse> {
        private ListTestGridSessionActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestGridSessionActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestGridSessionActionsResponse> nextPage(ListTestGridSessionActionsResponse previousPage) {
            if (previousPage == null) {
                return ListTestGridSessionActionsPublisher.this.client.listTestGridSessionActions(ListTestGridSessionActionsPublisher.this.firstRequest);
            }
            return ListTestGridSessionActionsPublisher.this.client.listTestGridSessionActions((ListTestGridSessionActionsRequest)((Object)ListTestGridSessionActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

