/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceFormFactor {
    PHONE("PHONE"),
    TABLET("TABLET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceFormFactor> VALUE_MAP;
    private final String value;

    private DeviceFormFactor(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceFormFactor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceFormFactor> knownValues() {
        EnumSet<DeviceFormFactor> knownValues = EnumSet.allOf(DeviceFormFactor.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceFormFactor.class, DeviceFormFactor::toString);
    }
}

