/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.RejectChoice;
import software.amazon.awssdk.services.datazone.model.RejectChoicesCopier;
import software.amazon.awssdk.services.datazone.model.RejectRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RejectPredictionsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, RejectPredictionsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::clientToken)).setter(RejectPredictionsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::domainIdentifier)).setter(RejectPredictionsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::identifier)).setter(RejectPredictionsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<List<RejectChoice>> REJECT_CHOICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rejectChoices").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::rejectChoices)).setter(RejectPredictionsRequest.setter(Builder::rejectChoices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectChoices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RejectChoice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RejectRule> REJECT_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rejectRule").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::rejectRule)).setter(RejectPredictionsRequest.setter(Builder::rejectRule)).constructor(RejectRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rejectRule").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(RejectPredictionsRequest.getter(RejectPredictionsRequest::revision)).setter(RejectPredictionsRequest.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, REJECT_CHOICES_FIELD, REJECT_RULE_FIELD, REVISION_FIELD));
    private final String clientToken;
    private final String domainIdentifier;
    private final String identifier;
    private final List<RejectChoice> rejectChoices;
    private final RejectRule rejectRule;
    private final String revision;

    private RejectPredictionsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.rejectChoices = builder.rejectChoices;
        this.rejectRule = builder.rejectRule;
        this.revision = builder.revision;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final boolean hasRejectChoices() {
        return this.rejectChoices != null && !(this.rejectChoices instanceof SdkAutoConstructList);
    }

    public final List<RejectChoice> rejectChoices() {
        return this.rejectChoices;
    }

    public final RejectRule rejectRule() {
        return this.rejectRule;
    }

    public final String revision() {
        return this.revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRejectChoices() ? this.rejectChoices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectPredictionsRequest)) {
            return false;
        }
        RejectPredictionsRequest other = (RejectPredictionsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && this.hasRejectChoices() == other.hasRejectChoices() && Objects.equals(this.rejectChoices(), other.rejectChoices()) && Objects.equals(this.rejectRule(), other.rejectRule()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"RejectPredictionsRequest").add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("RejectChoices", this.hasRejectChoices() ? this.rejectChoices() : null).add("RejectRule", (Object)this.rejectRule()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "rejectChoices": {
                return Optional.ofNullable(clazz.cast(this.rejectChoices()));
            }
            case "rejectRule": {
                return Optional.ofNullable(clazz.cast(this.rejectRule()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectPredictionsRequest, T> g) {
        return obj -> g.apply((RejectPredictionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private String identifier;
        private List<RejectChoice> rejectChoices = DefaultSdkAutoConstructList.getInstance();
        private RejectRule rejectRule;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectPredictionsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.rejectChoices(model.rejectChoices);
            this.rejectRule(model.rejectRule);
            this.revision(model.revision);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<RejectChoice.Builder> getRejectChoices() {
            List<RejectChoice.Builder> result = RejectChoicesCopier.copyToBuilder(this.rejectChoices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRejectChoices(Collection<RejectChoice.BuilderImpl> rejectChoices) {
            this.rejectChoices = RejectChoicesCopier.copyFromBuilder(rejectChoices);
        }

        @Override
        public final Builder rejectChoices(Collection<RejectChoice> rejectChoices) {
            this.rejectChoices = RejectChoicesCopier.copy(rejectChoices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectChoices(RejectChoice ... rejectChoices) {
            this.rejectChoices(Arrays.asList(rejectChoices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectChoices(Consumer<RejectChoice.Builder> ... rejectChoices) {
            this.rejectChoices(Stream.of(rejectChoices).map(c -> (RejectChoice)((RejectChoice.Builder)RejectChoice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final RejectRule.Builder getRejectRule() {
            return this.rejectRule != null ? this.rejectRule.toBuilder() : null;
        }

        public final void setRejectRule(RejectRule.BuilderImpl rejectRule) {
            this.rejectRule = rejectRule != null ? rejectRule.build() : null;
        }

        @Override
        public final Builder rejectRule(RejectRule rejectRule) {
            this.rejectRule = rejectRule;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectPredictionsRequest build() {
            return new RejectPredictionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RejectPredictionsRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder rejectChoices(Collection<RejectChoice> var1);

        public Builder rejectChoices(RejectChoice ... var1);

        public Builder rejectChoices(Consumer<RejectChoice.Builder> ... var1);

        public Builder rejectRule(RejectRule var1);

        default public Builder rejectRule(Consumer<RejectRule.Builder> rejectRule) {
            return this.rejectRule((RejectRule)((RejectRule.Builder)RejectRule.builder().applyMutation(rejectRule)).build());
        }

        public Builder revision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

