/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datasync.model.AgentArnListCopier;
import software.amazon.awssdk.services.datasync.model.AzureAccessTier;
import software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType;
import software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration;
import software.amazon.awssdk.services.datasync.model.AzureBlobType;
import software.amazon.awssdk.services.datasync.model.DataSyncRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLocationAzureBlobRequest
extends DataSyncRequest
implements ToCopyableBuilder<Builder, UpdateLocationAzureBlobRequest> {
    private static final SdkField<String> LOCATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocationArn").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::locationArn)).setter(UpdateLocationAzureBlobRequest.setter(Builder::locationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocationArn").build()}).build();
    private static final SdkField<String> SUBDIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdirectory").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::subdirectory)).setter(UpdateLocationAzureBlobRequest.setter(Builder::subdirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdirectory").build()}).build();
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationType").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::authenticationTypeAsString)).setter(UpdateLocationAzureBlobRequest.setter(Builder::authenticationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build()}).build();
    private static final SdkField<AzureBlobSasConfiguration> SAS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SasConfiguration").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::sasConfiguration)).setter(UpdateLocationAzureBlobRequest.setter(Builder::sasConfiguration)).constructor(AzureBlobSasConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SasConfiguration").build()}).build();
    private static final SdkField<String> BLOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BlobType").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::blobTypeAsString)).setter(UpdateLocationAzureBlobRequest.setter(Builder::blobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlobType").build()}).build();
    private static final SdkField<String> ACCESS_TIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessTier").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::accessTierAsString)).setter(UpdateLocationAzureBlobRequest.setter(Builder::accessTier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessTier").build()}).build();
    private static final SdkField<List<String>> AGENT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentArns").getter(UpdateLocationAzureBlobRequest.getter(UpdateLocationAzureBlobRequest::agentArns)).setter(UpdateLocationAzureBlobRequest.setter(Builder::agentArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_ARN_FIELD, SUBDIRECTORY_FIELD, AUTHENTICATION_TYPE_FIELD, SAS_CONFIGURATION_FIELD, BLOB_TYPE_FIELD, ACCESS_TIER_FIELD, AGENT_ARNS_FIELD));
    private final String locationArn;
    private final String subdirectory;
    private final String authenticationType;
    private final AzureBlobSasConfiguration sasConfiguration;
    private final String blobType;
    private final String accessTier;
    private final List<String> agentArns;

    private UpdateLocationAzureBlobRequest(BuilderImpl builder) {
        super(builder);
        this.locationArn = builder.locationArn;
        this.subdirectory = builder.subdirectory;
        this.authenticationType = builder.authenticationType;
        this.sasConfiguration = builder.sasConfiguration;
        this.blobType = builder.blobType;
        this.accessTier = builder.accessTier;
        this.agentArns = builder.agentArns;
    }

    public final String locationArn() {
        return this.locationArn;
    }

    public final String subdirectory() {
        return this.subdirectory;
    }

    public final AzureBlobAuthenticationType authenticationType() {
        return AzureBlobAuthenticationType.fromValue(this.authenticationType);
    }

    public final String authenticationTypeAsString() {
        return this.authenticationType;
    }

    public final AzureBlobSasConfiguration sasConfiguration() {
        return this.sasConfiguration;
    }

    public final AzureBlobType blobType() {
        return AzureBlobType.fromValue(this.blobType);
    }

    public final String blobTypeAsString() {
        return this.blobType;
    }

    public final AzureAccessTier accessTier() {
        return AzureAccessTier.fromValue(this.accessTier);
    }

    public final String accessTierAsString() {
        return this.accessTier;
    }

    public final boolean hasAgentArns() {
        return this.agentArns != null && !(this.agentArns instanceof SdkAutoConstructList);
    }

    public final List<String> agentArns() {
        return this.agentArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.locationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sasConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessTierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentArns() ? this.agentArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLocationAzureBlobRequest)) {
            return false;
        }
        UpdateLocationAzureBlobRequest other = (UpdateLocationAzureBlobRequest)((Object)obj);
        return Objects.equals(this.locationArn(), other.locationArn()) && Objects.equals(this.subdirectory(), other.subdirectory()) && Objects.equals(this.authenticationTypeAsString(), other.authenticationTypeAsString()) && Objects.equals(this.sasConfiguration(), other.sasConfiguration()) && Objects.equals(this.blobTypeAsString(), other.blobTypeAsString()) && Objects.equals(this.accessTierAsString(), other.accessTierAsString()) && this.hasAgentArns() == other.hasAgentArns() && Objects.equals(this.agentArns(), other.agentArns());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLocationAzureBlobRequest").add("LocationArn", (Object)this.locationArn()).add("Subdirectory", (Object)this.subdirectory()).add("AuthenticationType", (Object)this.authenticationTypeAsString()).add("SasConfiguration", (Object)this.sasConfiguration()).add("BlobType", (Object)this.blobTypeAsString()).add("AccessTier", (Object)this.accessTierAsString()).add("AgentArns", this.hasAgentArns() ? this.agentArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocationArn": {
                return Optional.ofNullable(clazz.cast(this.locationArn()));
            }
            case "Subdirectory": {
                return Optional.ofNullable(clazz.cast(this.subdirectory()));
            }
            case "AuthenticationType": {
                return Optional.ofNullable(clazz.cast(this.authenticationTypeAsString()));
            }
            case "SasConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sasConfiguration()));
            }
            case "BlobType": {
                return Optional.ofNullable(clazz.cast(this.blobTypeAsString()));
            }
            case "AccessTier": {
                return Optional.ofNullable(clazz.cast(this.accessTierAsString()));
            }
            case "AgentArns": {
                return Optional.ofNullable(clazz.cast(this.agentArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLocationAzureBlobRequest, T> g) {
        return obj -> g.apply((UpdateLocationAzureBlobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataSyncRequest.BuilderImpl
    implements Builder {
        private String locationArn;
        private String subdirectory;
        private String authenticationType;
        private AzureBlobSasConfiguration sasConfiguration;
        private String blobType;
        private String accessTier;
        private List<String> agentArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLocationAzureBlobRequest model) {
            super(model);
            this.locationArn(model.locationArn);
            this.subdirectory(model.subdirectory);
            this.authenticationType(model.authenticationType);
            this.sasConfiguration(model.sasConfiguration);
            this.blobType(model.blobType);
            this.accessTier(model.accessTier);
            this.agentArns(model.agentArns);
        }

        public final String getLocationArn() {
            return this.locationArn;
        }

        public final void setLocationArn(String locationArn) {
            this.locationArn = locationArn;
        }

        @Override
        public final Builder locationArn(String locationArn) {
            this.locationArn = locationArn;
            return this;
        }

        public final String getSubdirectory() {
            return this.subdirectory;
        }

        public final void setSubdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
        }

        @Override
        public final Builder subdirectory(String subdirectory) {
            this.subdirectory = subdirectory;
            return this;
        }

        public final String getAuthenticationType() {
            return this.authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AzureBlobAuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final AzureBlobSasConfiguration.Builder getSasConfiguration() {
            return this.sasConfiguration != null ? this.sasConfiguration.toBuilder() : null;
        }

        public final void setSasConfiguration(AzureBlobSasConfiguration.BuilderImpl sasConfiguration) {
            this.sasConfiguration = sasConfiguration != null ? sasConfiguration.build() : null;
        }

        @Override
        public final Builder sasConfiguration(AzureBlobSasConfiguration sasConfiguration) {
            this.sasConfiguration = sasConfiguration;
            return this;
        }

        public final String getBlobType() {
            return this.blobType;
        }

        public final void setBlobType(String blobType) {
            this.blobType = blobType;
        }

        @Override
        public final Builder blobType(String blobType) {
            this.blobType = blobType;
            return this;
        }

        @Override
        public final Builder blobType(AzureBlobType blobType) {
            this.blobType(blobType == null ? null : blobType.toString());
            return this;
        }

        public final String getAccessTier() {
            return this.accessTier;
        }

        public final void setAccessTier(String accessTier) {
            this.accessTier = accessTier;
        }

        @Override
        public final Builder accessTier(String accessTier) {
            this.accessTier = accessTier;
            return this;
        }

        @Override
        public final Builder accessTier(AzureAccessTier accessTier) {
            this.accessTier(accessTier == null ? null : accessTier.toString());
            return this;
        }

        public final Collection<String> getAgentArns() {
            if (this.agentArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentArns;
        }

        public final void setAgentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
        }

        @Override
        public final Builder agentArns(Collection<String> agentArns) {
            this.agentArns = AgentArnListCopier.copy(agentArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentArns(String ... agentArns) {
            this.agentArns(Arrays.asList(agentArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLocationAzureBlobRequest build() {
            return new UpdateLocationAzureBlobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLocationAzureBlobRequest> {
        public Builder locationArn(String var1);

        public Builder subdirectory(String var1);

        public Builder authenticationType(String var1);

        public Builder authenticationType(AzureBlobAuthenticationType var1);

        public Builder sasConfiguration(AzureBlobSasConfiguration var1);

        default public Builder sasConfiguration(Consumer<AzureBlobSasConfiguration.Builder> sasConfiguration) {
            return this.sasConfiguration((AzureBlobSasConfiguration)((AzureBlobSasConfiguration.Builder)AzureBlobSasConfiguration.builder().applyMutation(sasConfiguration)).build());
        }

        public Builder blobType(String var1);

        public Builder blobType(AzureBlobType var1);

        public Builder accessTier(String var1);

        public Builder accessTier(AzureAccessTier var1);

        public Builder agentArns(Collection<String> var1);

        public Builder agentArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

