/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoveryJobListEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DiscoveryJobListEntry> {
    private static final SdkField<String> DISCOVERY_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryJobArn").getter(DiscoveryJobListEntry.getter(DiscoveryJobListEntry::discoveryJobArn)).setter(DiscoveryJobListEntry.setter(Builder::discoveryJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryJobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DiscoveryJobListEntry.getter(DiscoveryJobListEntry::statusAsString)).setter(DiscoveryJobListEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_JOB_ARN_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String discoveryJobArn;
    private final String status;

    private DiscoveryJobListEntry(BuilderImpl builder) {
        this.discoveryJobArn = builder.discoveryJobArn;
        this.status = builder.status;
    }

    public final String discoveryJobArn() {
        return this.discoveryJobArn;
    }

    public final DiscoveryJobStatus status() {
        return DiscoveryJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoveryJobListEntry)) {
            return false;
        }
        DiscoveryJobListEntry other = (DiscoveryJobListEntry)obj;
        return Objects.equals(this.discoveryJobArn(), other.discoveryJobArn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoveryJobListEntry").add("DiscoveryJobArn", (Object)this.discoveryJobArn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiscoveryJobArn": {
                return Optional.ofNullable(clazz.cast(this.discoveryJobArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DiscoveryJobListEntry, T> g) {
        return obj -> g.apply((DiscoveryJobListEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String discoveryJobArn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoveryJobListEntry model) {
            this.discoveryJobArn(model.discoveryJobArn);
            this.status(model.status);
        }

        public final String getDiscoveryJobArn() {
            return this.discoveryJobArn;
        }

        public final void setDiscoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
        }

        @Override
        public final Builder discoveryJobArn(String discoveryJobArn) {
            this.discoveryJobArn = discoveryJobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DiscoveryJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public DiscoveryJobListEntry build() {
            return new DiscoveryJobListEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DiscoveryJobListEntry> {
        public Builder discoveryJobArn(String var1);

        public Builder status(String var1);

        public Builder status(DiscoveryJobStatus var1);
    }
}

