/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The storage capacity of an on-premises storage system resource (for example, a volume).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Capacity implements SdkPojo, Serializable, ToCopyableBuilder<Capacity.Builder, Capacity> {
    private static final SdkField<Long> USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Used")
            .getter(getter(Capacity::used)).setter(setter(Builder::used))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Used").build()).build();

    private static final SdkField<Long> PROVISIONED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("Provisioned").getter(getter(Capacity::provisioned)).setter(setter(Builder::provisioned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Provisioned").build()).build();

    private static final SdkField<Long> LOGICAL_USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LogicalUsed").getter(getter(Capacity::logicalUsed)).setter(setter(Builder::logicalUsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalUsed").build()).build();

    private static final SdkField<Long> CLUSTER_CLOUD_STORAGE_USED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ClusterCloudStorageUsed").getter(getter(Capacity::clusterCloudStorageUsed))
            .setter(setter(Builder::clusterCloudStorageUsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCloudStorageUsed").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USED_FIELD, PROVISIONED_FIELD,
            LOGICAL_USED_FIELD, CLUSTER_CLOUD_STORAGE_USED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long used;

    private final Long provisioned;

    private final Long logicalUsed;

    private final Long clusterCloudStorageUsed;

    private Capacity(BuilderImpl builder) {
        this.used = builder.used;
        this.provisioned = builder.provisioned;
        this.logicalUsed = builder.logicalUsed;
        this.clusterCloudStorageUsed = builder.clusterCloudStorageUsed;
    }

    /**
     * <p>
     * The amount of space that's being used in a storage system resource.
     * </p>
     * 
     * @return The amount of space that's being used in a storage system resource.
     */
    public final Long used() {
        return used;
    }

    /**
     * <p>
     * The total amount of space available in a storage system resource.
     * </p>
     * 
     * @return The total amount of space available in a storage system resource.
     */
    public final Long provisioned() {
        return provisioned;
    }

    /**
     * <p>
     * The amount of space that's being used in a storage system resource without accounting for compression or
     * deduplication.
     * </p>
     * 
     * @return The amount of space that's being used in a storage system resource without accounting for compression or
     *         deduplication.
     */
    public final Long logicalUsed() {
        return logicalUsed;
    }

    /**
     * <p>
     * The amount of space in the cluster that's in cloud storage (for example, if you're using data tiering).
     * </p>
     * 
     * @return The amount of space in the cluster that's in cloud storage (for example, if you're using data tiering).
     */
    public final Long clusterCloudStorageUsed() {
        return clusterCloudStorageUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(used());
        hashCode = 31 * hashCode + Objects.hashCode(provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(logicalUsed());
        hashCode = 31 * hashCode + Objects.hashCode(clusterCloudStorageUsed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Capacity)) {
            return false;
        }
        Capacity other = (Capacity) obj;
        return Objects.equals(used(), other.used()) && Objects.equals(provisioned(), other.provisioned())
                && Objects.equals(logicalUsed(), other.logicalUsed())
                && Objects.equals(clusterCloudStorageUsed(), other.clusterCloudStorageUsed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Capacity").add("Used", used()).add("Provisioned", provisioned())
                .add("LogicalUsed", logicalUsed()).add("ClusterCloudStorageUsed", clusterCloudStorageUsed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Used":
            return Optional.ofNullable(clazz.cast(used()));
        case "Provisioned":
            return Optional.ofNullable(clazz.cast(provisioned()));
        case "LogicalUsed":
            return Optional.ofNullable(clazz.cast(logicalUsed()));
        case "ClusterCloudStorageUsed":
            return Optional.ofNullable(clazz.cast(clusterCloudStorageUsed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Capacity, T> g) {
        return obj -> g.apply((Capacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Capacity> {
        /**
         * <p>
         * The amount of space that's being used in a storage system resource.
         * </p>
         * 
         * @param used
         *        The amount of space that's being used in a storage system resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder used(Long used);

        /**
         * <p>
         * The total amount of space available in a storage system resource.
         * </p>
         * 
         * @param provisioned
         *        The total amount of space available in a storage system resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioned(Long provisioned);

        /**
         * <p>
         * The amount of space that's being used in a storage system resource without accounting for compression or
         * deduplication.
         * </p>
         * 
         * @param logicalUsed
         *        The amount of space that's being used in a storage system resource without accounting for compression
         *        or deduplication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicalUsed(Long logicalUsed);

        /**
         * <p>
         * The amount of space in the cluster that's in cloud storage (for example, if you're using data tiering).
         * </p>
         * 
         * @param clusterCloudStorageUsed
         *        The amount of space in the cluster that's in cloud storage (for example, if you're using data
         *        tiering).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterCloudStorageUsed(Long clusterCloudStorageUsed);
    }

    static final class BuilderImpl implements Builder {
        private Long used;

        private Long provisioned;

        private Long logicalUsed;

        private Long clusterCloudStorageUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Capacity model) {
            used(model.used);
            provisioned(model.provisioned);
            logicalUsed(model.logicalUsed);
            clusterCloudStorageUsed(model.clusterCloudStorageUsed);
        }

        public final Long getUsed() {
            return used;
        }

        public final void setUsed(Long used) {
            this.used = used;
        }

        @Override
        public final Builder used(Long used) {
            this.used = used;
            return this;
        }

        public final Long getProvisioned() {
            return provisioned;
        }

        public final void setProvisioned(Long provisioned) {
            this.provisioned = provisioned;
        }

        @Override
        public final Builder provisioned(Long provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final Long getLogicalUsed() {
            return logicalUsed;
        }

        public final void setLogicalUsed(Long logicalUsed) {
            this.logicalUsed = logicalUsed;
        }

        @Override
        public final Builder logicalUsed(Long logicalUsed) {
            this.logicalUsed = logicalUsed;
            return this;
        }

        public final Long getClusterCloudStorageUsed() {
            return clusterCloudStorageUsed;
        }

        public final void setClusterCloudStorageUsed(Long clusterCloudStorageUsed) {
            this.clusterCloudStorageUsed = clusterCloudStorageUsed;
        }

        @Override
        public final Builder clusterCloudStorageUsed(Long clusterCloudStorageUsed) {
            this.clusterCloudStorageUsed = clusterCloudStorageUsed;
            return this;
        }

        @Override
        public Capacity build() {
            return new Capacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
