/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datapipeline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datapipeline.model.DataPipelineResponse;
import software.amazon.awssdk.services.datapipeline.model.ValidationError;
import software.amazon.awssdk.services.datapipeline.model.ValidationErrorsCopier;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarning;
import software.amazon.awssdk.services.datapipeline.model.ValidationWarningsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidatePipelineDefinitionResponse
extends DataPipelineResponse
implements ToCopyableBuilder<Builder, ValidatePipelineDefinitionResponse> {
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationErrors").getter(ValidatePipelineDefinitionResponse.getter(ValidatePipelineDefinitionResponse::validationErrors)).setter(ValidatePipelineDefinitionResponse.setter(Builder::validationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ValidationWarning>> VALIDATION_WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationWarnings").getter(ValidatePipelineDefinitionResponse.getter(ValidatePipelineDefinitionResponse::validationWarnings)).setter(ValidatePipelineDefinitionResponse.setter(Builder::validationWarnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationWarnings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ERRORED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("errored").getter(ValidatePipelineDefinitionResponse.getter(ValidatePipelineDefinitionResponse::errored)).setter(ValidatePipelineDefinitionResponse.setter(Builder::errored)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errored").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALIDATION_ERRORS_FIELD, VALIDATION_WARNINGS_FIELD, ERRORED_FIELD));
    private final List<ValidationError> validationErrors;
    private final List<ValidationWarning> validationWarnings;
    private final Boolean errored;

    private ValidatePipelineDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.validationErrors = builder.validationErrors;
        this.validationWarnings = builder.validationWarnings;
        this.errored = builder.errored;
    }

    public final boolean hasValidationErrors() {
        return this.validationErrors != null && !(this.validationErrors instanceof SdkAutoConstructList);
    }

    public final List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    public final boolean hasValidationWarnings() {
        return this.validationWarnings != null && !(this.validationWarnings instanceof SdkAutoConstructList);
    }

    public final List<ValidationWarning> validationWarnings() {
        return this.validationWarnings;
    }

    public final Boolean errored() {
        return this.errored;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationErrors() ? this.validationErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationWarnings() ? this.validationWarnings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errored());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePipelineDefinitionResponse)) {
            return false;
        }
        ValidatePipelineDefinitionResponse other = (ValidatePipelineDefinitionResponse)((Object)obj);
        return this.hasValidationErrors() == other.hasValidationErrors() && Objects.equals(this.validationErrors(), other.validationErrors()) && this.hasValidationWarnings() == other.hasValidationWarnings() && Objects.equals(this.validationWarnings(), other.validationWarnings()) && Objects.equals(this.errored(), other.errored());
    }

    public final String toString() {
        return ToString.builder((String)"ValidatePipelineDefinitionResponse").add("ValidationErrors", this.hasValidationErrors() ? this.validationErrors() : null).add("ValidationWarnings", this.hasValidationWarnings() ? this.validationWarnings() : null).add("Errored", (Object)this.errored()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "validationErrors": {
                return Optional.ofNullable(clazz.cast(this.validationErrors()));
            }
            case "validationWarnings": {
                return Optional.ofNullable(clazz.cast(this.validationWarnings()));
            }
            case "errored": {
                return Optional.ofNullable(clazz.cast(this.errored()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidatePipelineDefinitionResponse, T> g) {
        return obj -> g.apply((ValidatePipelineDefinitionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataPipelineResponse.BuilderImpl
    implements Builder {
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();
        private List<ValidationWarning> validationWarnings = DefaultSdkAutoConstructList.getInstance();
        private Boolean errored;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePipelineDefinitionResponse model) {
            super(model);
            this.validationErrors(model.validationErrors);
            this.validationWarnings(model.validationWarnings);
            this.errored(model.errored);
        }

        public final List<ValidationError.Builder> getValidationErrors() {
            List<ValidationError.Builder> result = ValidationErrorsCopier.copyToBuilder(this.validationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder> ... validationErrors) {
            this.validationErrors(Stream.of(validationErrors).map(c -> (ValidationError)((ValidationError.Builder)ValidationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ValidationWarning.Builder> getValidationWarnings() {
            List<ValidationWarning.Builder> result = ValidationWarningsCopier.copyToBuilder(this.validationWarnings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationWarnings(Collection<ValidationWarning.BuilderImpl> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copyFromBuilder(validationWarnings);
        }

        @Override
        public final Builder validationWarnings(Collection<ValidationWarning> validationWarnings) {
            this.validationWarnings = ValidationWarningsCopier.copy(validationWarnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(ValidationWarning ... validationWarnings) {
            this.validationWarnings(Arrays.asList(validationWarnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationWarnings(Consumer<ValidationWarning.Builder> ... validationWarnings) {
            this.validationWarnings(Stream.of(validationWarnings).map(c -> (ValidationWarning)((ValidationWarning.Builder)ValidationWarning.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getErrored() {
            return this.errored;
        }

        public final void setErrored(Boolean errored) {
            this.errored = errored;
        }

        @Override
        public final Builder errored(Boolean errored) {
            this.errored = errored;
            return this;
        }

        @Override
        public ValidatePipelineDefinitionResponse build() {
            return new ValidatePipelineDefinitionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataPipelineResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidatePipelineDefinitionResponse> {
        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder validationErrors(Consumer<ValidationError.Builder> ... var1);

        public Builder validationWarnings(Collection<ValidationWarning> var1);

        public Builder validationWarnings(ValidationWarning ... var1);

        public Builder validationWarnings(Consumer<ValidationWarning.Builder> ... var1);

        public Builder errored(Boolean var1);
    }
}

