/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.dataexchange.DataExchangeClient;
import software.amazon.awssdk.services.dataexchange.internal.UserAgentUtils;
import software.amazon.awssdk.services.dataexchange.model.EventActionEntry;
import software.amazon.awssdk.services.dataexchange.model.ListEventActionsRequest;
import software.amazon.awssdk.services.dataexchange.model.ListEventActionsResponse;

public class ListEventActionsIterable
implements SdkIterable<ListEventActionsResponse> {
    private final DataExchangeClient client;
    private final ListEventActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventActionsIterable(DataExchangeClient client, ListEventActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEventActionsResponseFetcher();
    }

    public Iterator<ListEventActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventActionEntry> eventActions() {
        Function<ListEventActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventActions() != null) {
                return response.eventActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventActionsResponseFetcher
    implements SyncPageFetcher<ListEventActionsResponse> {
        private ListEventActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventActionsResponse nextPage(ListEventActionsResponse previousPage) {
            if (previousPage == null) {
                return ListEventActionsIterable.this.client.listEventActions(ListEventActionsIterable.this.firstRequest);
            }
            return ListEventActionsIterable.this.client.listEventActions((ListEventActionsRequest)((Object)ListEventActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

