/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dataexchange.model.Code;
import software.amazon.awssdk.services.dataexchange.model.Details;
import software.amazon.awssdk.services.dataexchange.model.JobErrorLimitName;
import software.amazon.awssdk.services.dataexchange.model.JobErrorResourceTypes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobError> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(JobError.getter(JobError::codeAsString)).setter(JobError.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<Details> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Details").getter(JobError.getter(JobError::details)).setter(JobError.setter(Builder::details)).constructor(Details::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Details").build()}).build();
    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LimitName").getter(JobError.getter(JobError::limitNameAsString)).setter(JobError.setter(Builder::limitName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()}).build();
    private static final SdkField<Double> LIMIT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LimitValue").getter(JobError.getter(JobError::limitValue)).setter(JobError.setter(Builder::limitValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValue").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(JobError.getter(JobError::message)).setter(JobError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(JobError.getter(JobError::resourceId)).setter(JobError.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(JobError.getter(JobError::resourceTypeAsString)).setter(JobError.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, DETAILS_FIELD, LIMIT_NAME_FIELD, LIMIT_VALUE_FIELD, MESSAGE_FIELD, RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String code;
    private final Details details;
    private final String limitName;
    private final Double limitValue;
    private final String message;
    private final String resourceId;
    private final String resourceType;

    private JobError(BuilderImpl builder) {
        this.code = builder.code;
        this.details = builder.details;
        this.limitName = builder.limitName;
        this.limitValue = builder.limitValue;
        this.message = builder.message;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
    }

    public final Code code() {
        return Code.fromValue(this.code);
    }

    public final String codeAsString() {
        return this.code;
    }

    public final Details details() {
        return this.details;
    }

    public final JobErrorLimitName limitName() {
        return JobErrorLimitName.fromValue(this.limitName);
    }

    public final String limitNameAsString() {
        return this.limitName;
    }

    public final Double limitValue() {
        return this.limitValue;
    }

    public final String message() {
        return this.message;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final JobErrorResourceTypes resourceType() {
        return JobErrorResourceTypes.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.details());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.limitValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobError)) {
            return false;
        }
        JobError other = (JobError)obj;
        return Objects.equals(this.codeAsString(), other.codeAsString()) && Objects.equals(this.details(), other.details()) && Objects.equals(this.limitNameAsString(), other.limitNameAsString()) && Objects.equals(this.limitValue(), other.limitValue()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobError").add("Code", (Object)this.codeAsString()).add("Details", (Object)this.details()).add("LimitName", (Object)this.limitNameAsString()).add("LimitValue", (Object)this.limitValue()).add("Message", (Object)this.message()).add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.codeAsString()));
            }
            case "Details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
            case "LimitName": {
                return Optional.ofNullable(clazz.cast(this.limitNameAsString()));
            }
            case "LimitValue": {
                return Optional.ofNullable(clazz.cast(this.limitValue()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobError, T> g) {
        return obj -> g.apply((JobError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String code;
        private Details details;
        private String limitName;
        private Double limitValue;
        private String message;
        private String resourceId;
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(JobError model) {
            this.code(model.code);
            this.details(model.details);
            this.limitName(model.limitName);
            this.limitValue(model.limitValue);
            this.message(model.message);
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(Code code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final Details.Builder getDetails() {
            return this.details != null ? this.details.toBuilder() : null;
        }

        public final void setDetails(Details.BuilderImpl details) {
            this.details = details != null ? details.build() : null;
        }

        @Override
        public final Builder details(Details details) {
            this.details = details;
            return this;
        }

        public final String getLimitName() {
            return this.limitName;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        @Override
        public final Builder limitName(JobErrorLimitName limitName) {
            this.limitName(limitName == null ? null : limitName.toString());
            return this;
        }

        public final Double getLimitValue() {
            return this.limitValue;
        }

        public final void setLimitValue(Double limitValue) {
            this.limitValue = limitValue;
        }

        @Override
        public final Builder limitValue(Double limitValue) {
            this.limitValue = limitValue;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(JobErrorResourceTypes resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public JobError build() {
            return new JobError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobError> {
        public Builder code(String var1);

        public Builder code(Code var1);

        public Builder details(Details var1);

        default public Builder details(Consumer<Details.Builder> details) {
            return this.details((Details)((Details.Builder)Details.builder().applyMutation(details)).build());
        }

        public Builder limitName(String var1);

        public Builder limitName(JobErrorLimitName var1);

        public Builder limitValue(Double var1);

        public Builder message(String var1);

        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(JobErrorResourceTypes var1);
    }
}

