/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The threshold used with a non-aggregate check expression. The non-aggregate check expression will be applied to each
 * row in a specific column. Then the threshold will be used to determine whether the validation succeeds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Threshold implements SdkPojo, Serializable, ToCopyableBuilder<Threshold.Builder, Threshold> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(Threshold::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Threshold::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(Threshold::unitAsString)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD,
            UNIT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double value;

    private final String type;

    private final String unit;

    private Threshold(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.unit = builder.unit;
    }

    /**
     * <p>
     * The value of a threshold.
     * </p>
     * 
     * @return The value of a threshold.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the threshold
     * value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThresholdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
     *         threshold value.
     * @see ThresholdType
     */
    public final ThresholdType type() {
        return ThresholdType.fromValue(type);
    }

    /**
     * <p>
     * The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the threshold
     * value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThresholdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
     *         threshold value.
     * @see ThresholdType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link ThresholdUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
     * @see ThresholdUnit
     */
    public final ThresholdUnit unit() {
        return ThresholdUnit.fromValue(unit);
    }

    /**
     * <p>
     * Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #unit} will return
     * {@link ThresholdUnit#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #unitAsString}.
     * </p>
     * 
     * @return Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
     * @see ThresholdUnit
     */
    public final String unitAsString() {
        return unit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(unitAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Threshold)) {
            return false;
        }
        Threshold other = (Threshold) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(unitAsString(), other.unitAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Threshold").add("Value", value()).add("Type", typeAsString()).add("Unit", unitAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unitAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Threshold, T> g) {
        return obj -> g.apply((Threshold) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Threshold> {
        /**
         * <p>
         * The value of a threshold.
         * </p>
         * 
         * @param value
         *        The value of a threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
         * threshold value.
         * </p>
         * 
         * @param type
         *        The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
         *        threshold value.
         * @see ThresholdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThresholdType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
         * threshold value.
         * </p>
         * 
         * @param type
         *        The type of a threshold. Used for comparison of an actual count of rows that satisfy the rule to the
         *        threshold value.
         * @see ThresholdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThresholdType
         */
        Builder type(ThresholdType type);

        /**
         * <p>
         * Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
         * </p>
         * 
         * @param unit
         *        Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for
         *        validation.
         * @see ThresholdUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThresholdUnit
         */
        Builder unit(String unit);

        /**
         * <p>
         * Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for validation.
         * </p>
         * 
         * @param unit
         *        Unit of threshold value. Can be either a COUNT or PERCENTAGE of the full sample size used for
         *        validation.
         * @see ThresholdUnit
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThresholdUnit
         */
        Builder unit(ThresholdUnit unit);
    }

    static final class BuilderImpl implements Builder {
        private Double value;

        private String type;

        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(Threshold model) {
            value(model.value);
            type(model.type);
            unit(model.unit);
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThresholdType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(ThresholdUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        @Override
        public Threshold build() {
            return new Threshold(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
