/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InputFormat {
    CSV("CSV"),
    JSON("JSON"),
    PARQUET("PARQUET"),
    EXCEL("EXCEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputFormat> VALUE_MAP;
    private final String value;

    private InputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InputFormat> knownValues() {
        EnumSet<InputFormat> knownValues = EnumSet.allOf(InputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InputFormat.class, InputFormat::toString);
    }
}

