/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClientBuilder;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesServiceClientConfiguration;
import software.amazon.awssdk.services.customerprofiles.DefaultCustomerProfilesBaseClientBuilder;
import software.amazon.awssdk.services.customerprofiles.DefaultCustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.endpoints.CustomerProfilesEndpointProvider;

@SdkInternalApi
final class DefaultCustomerProfilesClientBuilder
extends DefaultCustomerProfilesBaseClientBuilder<CustomerProfilesClientBuilder, CustomerProfilesClient>
implements CustomerProfilesClientBuilder {
    DefaultCustomerProfilesClientBuilder() {
    }

    @Override
    public DefaultCustomerProfilesClientBuilder endpointProvider(CustomerProfilesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CustomerProfilesClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCustomerProfilesClientBuilder.validateClientOptions(clientConfiguration);
        CustomerProfilesServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCustomerProfilesClient client = new DefaultCustomerProfilesClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CustomerProfilesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CustomerProfilesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

