/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5.packets;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.crt.mqtt5.packets.UserProperty;

public class UnsubscribePacket {
    private List<String> subscriptions;
    private List<UserProperty> userProperties;

    private UnsubscribePacket(UnsubscribePacketBuilder builder) {
        this.userProperties = builder.userProperties;
        this.subscriptions = builder.subscriptions;
    }

    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public static final class UnsubscribePacketBuilder {
        private List<String> subscriptions;
        private List<UserProperty> userProperties;

        public UnsubscribePacketBuilder withSubscription(String subscription) {
            if (this.subscriptions == null) {
                this.subscriptions = new ArrayList<String>();
            }
            this.subscriptions.add(subscription);
            return this;
        }

        public UnsubscribePacketBuilder withUserProperties(List<UserProperty> userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        public UnsubscribePacket build() {
            return new UnsubscribePacket(this);
        }
    }
}

