/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Metric {
    BLENDED_COST("BLENDED_COST"),
    UNBLENDED_COST("UNBLENDED_COST"),
    AMORTIZED_COST("AMORTIZED_COST"),
    NET_UNBLENDED_COST("NET_UNBLENDED_COST"),
    NET_AMORTIZED_COST("NET_AMORTIZED_COST"),
    USAGE_QUANTITY("USAGE_QUANTITY"),
    NORMALIZED_USAGE_AMOUNT("NORMALIZED_USAGE_AMOUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Metric> VALUE_MAP;
    private final String value;

    private Metric(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Metric fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Metric> knownValues() {
        EnumSet<Metric> knownValues = EnumSet.allOf(Metric.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Metric.class, Metric::toString);
    }
}

