/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;

public class GetSavingsPlansCoverageIterable
implements SdkIterable<GetSavingsPlansCoverageResponse> {
    private final CostExplorerClient client;
    private final GetSavingsPlansCoverageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetSavingsPlansCoverageIterable(CostExplorerClient client, GetSavingsPlansCoverageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetSavingsPlansCoverageResponseFetcher();
    }

    public Iterator<GetSavingsPlansCoverageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetSavingsPlansCoverageResponseFetcher
    implements SyncPageFetcher<GetSavingsPlansCoverageResponse> {
        private GetSavingsPlansCoverageResponseFetcher() {
        }

        public boolean hasNextPage(GetSavingsPlansCoverageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetSavingsPlansCoverageResponse nextPage(GetSavingsPlansCoverageResponse previousPage) {
            if (previousPage == null) {
                return GetSavingsPlansCoverageIterable.this.client.getSavingsPlansCoverage(GetSavingsPlansCoverageIterable.this.firstRequest);
            }
            return GetSavingsPlansCoverageIterable.this.client.getSavingsPlansCoverage((GetSavingsPlansCoverageRequest)((Object)GetSavingsPlansCoverageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

