/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes;
import software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributesListCopier;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinition;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinitionsCopier;
import software.amazon.awssdk.services.costexplorer.model.ResultByTime;
import software.amazon.awssdk.services.costexplorer.model.ResultsByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostAndUsageResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetCostAndUsageResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetCostAndUsageResponse.getter(GetCostAndUsageResponse::nextPageToken)).setter(GetCostAndUsageResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<List<GroupDefinition>> GROUP_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupDefinitions").getter(GetCostAndUsageResponse.getter(GetCostAndUsageResponse::groupDefinitions)).setter(GetCostAndUsageResponse.setter(Builder::groupDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResultByTime>> RESULTS_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultsByTime").getter(GetCostAndUsageResponse.getter(GetCostAndUsageResponse::resultsByTime)).setter(GetCostAndUsageResponse.setter(Builder::resultsByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsByTime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultByTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DimensionValuesWithAttributes>> DIMENSION_VALUE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionValueAttributes").getter(GetCostAndUsageResponse.getter(GetCostAndUsageResponse::dimensionValueAttributes)).setter(GetCostAndUsageResponse.setter(Builder::dimensionValueAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionValuesWithAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, GROUP_DEFINITIONS_FIELD, RESULTS_BY_TIME_FIELD, DIMENSION_VALUE_ATTRIBUTES_FIELD));
    private final String nextPageToken;
    private final List<GroupDefinition> groupDefinitions;
    private final List<ResultByTime> resultsByTime;
    private final List<DimensionValuesWithAttributes> dimensionValueAttributes;

    private GetCostAndUsageResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.groupDefinitions = builder.groupDefinitions;
        this.resultsByTime = builder.resultsByTime;
        this.dimensionValueAttributes = builder.dimensionValueAttributes;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final boolean hasGroupDefinitions() {
        return this.groupDefinitions != null && !(this.groupDefinitions instanceof SdkAutoConstructList);
    }

    public final List<GroupDefinition> groupDefinitions() {
        return this.groupDefinitions;
    }

    public final boolean hasResultsByTime() {
        return this.resultsByTime != null && !(this.resultsByTime instanceof SdkAutoConstructList);
    }

    public final List<ResultByTime> resultsByTime() {
        return this.resultsByTime;
    }

    public final boolean hasDimensionValueAttributes() {
        return this.dimensionValueAttributes != null && !(this.dimensionValueAttributes instanceof SdkAutoConstructList);
    }

    public final List<DimensionValuesWithAttributes> dimensionValueAttributes() {
        return this.dimensionValueAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupDefinitions() ? this.groupDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultsByTime() ? this.resultsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionValueAttributes() ? this.dimensionValueAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageResponse)) {
            return false;
        }
        GetCostAndUsageResponse other = (GetCostAndUsageResponse)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && this.hasGroupDefinitions() == other.hasGroupDefinitions() && Objects.equals(this.groupDefinitions(), other.groupDefinitions()) && this.hasResultsByTime() == other.hasResultsByTime() && Objects.equals(this.resultsByTime(), other.resultsByTime()) && this.hasDimensionValueAttributes() == other.hasDimensionValueAttributes() && Objects.equals(this.dimensionValueAttributes(), other.dimensionValueAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostAndUsageResponse").add("NextPageToken", (Object)this.nextPageToken()).add("GroupDefinitions", this.hasGroupDefinitions() ? this.groupDefinitions() : null).add("ResultsByTime", this.hasResultsByTime() ? this.resultsByTime() : null).add("DimensionValueAttributes", this.hasDimensionValueAttributes() ? this.dimensionValueAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "GroupDefinitions": {
                return Optional.ofNullable(clazz.cast(this.groupDefinitions()));
            }
            case "ResultsByTime": {
                return Optional.ofNullable(clazz.cast(this.resultsByTime()));
            }
            case "DimensionValueAttributes": {
                return Optional.ofNullable(clazz.cast(this.dimensionValueAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageResponse, T> g) {
        return obj -> g.apply((GetCostAndUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private List<GroupDefinition> groupDefinitions = DefaultSdkAutoConstructList.getInstance();
        private List<ResultByTime> resultsByTime = DefaultSdkAutoConstructList.getInstance();
        private List<DimensionValuesWithAttributes> dimensionValueAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageResponse model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.groupDefinitions(model.groupDefinitions);
            this.resultsByTime(model.resultsByTime);
            this.dimensionValueAttributes(model.dimensionValueAttributes);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupDefinitions() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupDefinitions(Collection<GroupDefinition.BuilderImpl> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copyFromBuilder(groupDefinitions);
        }

        @Override
        public final Builder groupDefinitions(Collection<GroupDefinition> groupDefinitions) {
            this.groupDefinitions = GroupDefinitionsCopier.copy(groupDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(GroupDefinition ... groupDefinitions) {
            this.groupDefinitions(Arrays.asList(groupDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupDefinitions(Consumer<GroupDefinition.Builder> ... groupDefinitions) {
            this.groupDefinitions(Stream.of(groupDefinitions).map(c -> (GroupDefinition)((GroupDefinition.Builder)GroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResultByTime.Builder> getResultsByTime() {
            List<ResultByTime.Builder> result = ResultsByTimeCopier.copyToBuilder(this.resultsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultsByTime(Collection<ResultByTime.BuilderImpl> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copyFromBuilder(resultsByTime);
        }

        @Override
        public final Builder resultsByTime(Collection<ResultByTime> resultsByTime) {
            this.resultsByTime = ResultsByTimeCopier.copy(resultsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(ResultByTime ... resultsByTime) {
            this.resultsByTime(Arrays.asList(resultsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultsByTime(Consumer<ResultByTime.Builder> ... resultsByTime) {
            this.resultsByTime(Stream.of(resultsByTime).map(c -> (ResultByTime)((ResultByTime.Builder)ResultByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DimensionValuesWithAttributes.Builder> getDimensionValueAttributes() {
            List<DimensionValuesWithAttributes.Builder> result = DimensionValuesWithAttributesListCopier.copyToBuilder(this.dimensionValueAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionValueAttributes(Collection<DimensionValuesWithAttributes.BuilderImpl> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copyFromBuilder(dimensionValueAttributes);
        }

        @Override
        public final Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> dimensionValueAttributes) {
            this.dimensionValueAttributes = DimensionValuesWithAttributesListCopier.copy(dimensionValueAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(DimensionValuesWithAttributes ... dimensionValueAttributes) {
            this.dimensionValueAttributes(Arrays.asList(dimensionValueAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder> ... dimensionValueAttributes) {
            this.dimensionValueAttributes(Stream.of(dimensionValueAttributes).map(c -> (DimensionValuesWithAttributes)((DimensionValuesWithAttributes.Builder)DimensionValuesWithAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCostAndUsageResponse build() {
            return new GetCostAndUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostAndUsageResponse> {
        public Builder nextPageToken(String var1);

        public Builder groupDefinitions(Collection<GroupDefinition> var1);

        public Builder groupDefinitions(GroupDefinition ... var1);

        public Builder groupDefinitions(Consumer<GroupDefinition.Builder> ... var1);

        public Builder resultsByTime(Collection<ResultByTime> var1);

        public Builder resultsByTime(ResultByTime ... var1);

        public Builder resultsByTime(Consumer<ResultByTime.Builder> ... var1);

        public Builder dimensionValueAttributes(Collection<DimensionValuesWithAttributes> var1);

        public Builder dimensionValueAttributes(DimensionValuesWithAttributes ... var1);

        public Builder dimensionValueAttributes(Consumer<DimensionValuesWithAttributes.Builder> ... var1);
    }
}

