/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesRequest;
import software.amazon.awssdk.services.connectcases.model.LayoutConfiguration;
import software.amazon.awssdk.services.connectcases.model.RequiredField;
import software.amazon.awssdk.services.connectcases.model.RequiredFieldListCopier;
import software.amazon.awssdk.services.connectcases.model.TemplateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTemplateRequest
extends ConnectCasesRequest
implements ToCopyableBuilder<Builder, CreateTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateTemplateRequest.getter(CreateTemplateRequest::description)).setter(CreateTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(CreateTemplateRequest.getter(CreateTemplateRequest::domainId)).setter(CreateTemplateRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()}).build();
    private static final SdkField<LayoutConfiguration> LAYOUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("layoutConfiguration").getter(CreateTemplateRequest.getter(CreateTemplateRequest::layoutConfiguration)).setter(CreateTemplateRequest.setter(Builder::layoutConfiguration)).constructor(LayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layoutConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTemplateRequest.getter(CreateTemplateRequest::name)).setter(CreateTemplateRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<RequiredField>> REQUIRED_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredFields").getter(CreateTemplateRequest.getter(CreateTemplateRequest::requiredFields)).setter(CreateTemplateRequest.setter(Builder::requiredFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredFields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequiredField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateTemplateRequest.getter(CreateTemplateRequest::statusAsString)).setter(CreateTemplateRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_ID_FIELD, LAYOUT_CONFIGURATION_FIELD, NAME_FIELD, REQUIRED_FIELDS_FIELD, STATUS_FIELD));
    private final String description;
    private final String domainId;
    private final LayoutConfiguration layoutConfiguration;
    private final String name;
    private final List<RequiredField> requiredFields;
    private final String status;

    private CreateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.layoutConfiguration = builder.layoutConfiguration;
        this.name = builder.name;
        this.requiredFields = builder.requiredFields;
        this.status = builder.status;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final LayoutConfiguration layoutConfiguration() {
        return this.layoutConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasRequiredFields() {
        return this.requiredFields != null && !(this.requiredFields instanceof SdkAutoConstructList);
    }

    public final List<RequiredField> requiredFields() {
        return this.requiredFields;
    }

    public final TemplateStatus status() {
        return TemplateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.layoutConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredFields() ? this.requiredFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTemplateRequest)) {
            return false;
        }
        CreateTemplateRequest other = (CreateTemplateRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.layoutConfiguration(), other.layoutConfiguration()) && Objects.equals(this.name(), other.name()) && this.hasRequiredFields() == other.hasRequiredFields() && Objects.equals(this.requiredFields(), other.requiredFields()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTemplateRequest").add("Description", (Object)this.description()).add("DomainId", (Object)this.domainId()).add("LayoutConfiguration", (Object)this.layoutConfiguration()).add("Name", (Object)this.name()).add("RequiredFields", this.hasRequiredFields() ? this.requiredFields() : null).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "layoutConfiguration": {
                return Optional.ofNullable(clazz.cast(this.layoutConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "requiredFields": {
                return Optional.ofNullable(clazz.cast(this.requiredFields()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTemplateRequest, T> g) {
        return obj -> g.apply((CreateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainId;
        private LayoutConfiguration layoutConfiguration;
        private String name;
        private List<RequiredField> requiredFields = DefaultSdkAutoConstructList.getInstance();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTemplateRequest model) {
            super(model);
            this.description(model.description);
            this.domainId(model.domainId);
            this.layoutConfiguration(model.layoutConfiguration);
            this.name(model.name);
            this.requiredFields(model.requiredFields);
            this.status(model.status);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final LayoutConfiguration.Builder getLayoutConfiguration() {
            return this.layoutConfiguration != null ? this.layoutConfiguration.toBuilder() : null;
        }

        public final void setLayoutConfiguration(LayoutConfiguration.BuilderImpl layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration != null ? layoutConfiguration.build() : null;
        }

        @Override
        public final Builder layoutConfiguration(LayoutConfiguration layoutConfiguration) {
            this.layoutConfiguration = layoutConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<RequiredField.Builder> getRequiredFields() {
            List<RequiredField.Builder> result = RequiredFieldListCopier.copyToBuilder(this.requiredFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRequiredFields(Collection<RequiredField.BuilderImpl> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copyFromBuilder(requiredFields);
        }

        @Override
        public final Builder requiredFields(Collection<RequiredField> requiredFields) {
            this.requiredFields = RequiredFieldListCopier.copy(requiredFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(RequiredField ... requiredFields) {
            this.requiredFields(Arrays.asList(requiredFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredFields(Consumer<RequiredField.Builder> ... requiredFields) {
            this.requiredFields(Stream.of(requiredFields).map(c -> (RequiredField)((RequiredField.Builder)RequiredField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TemplateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTemplateRequest build() {
            return new CreateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTemplateRequest> {
        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder layoutConfiguration(LayoutConfiguration var1);

        default public Builder layoutConfiguration(Consumer<LayoutConfiguration.Builder> layoutConfiguration) {
            return this.layoutConfiguration((LayoutConfiguration)((LayoutConfiguration.Builder)LayoutConfiguration.builder().applyMutation(layoutConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder requiredFields(Collection<RequiredField> var1);

        public Builder requiredFields(RequiredField ... var1);

        public Builder requiredFields(Consumer<RequiredField.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(TemplateStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

