/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateContactFlowModuleContentRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateContactFlowModuleContentRequest.Builder, UpdateContactFlowModuleContentRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateContactFlowModuleContentRequest::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> CONTACT_FLOW_MODULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactFlowModuleId").getter(getter(UpdateContactFlowModuleContentRequest::contactFlowModuleId))
            .setter(setter(Builder::contactFlowModuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ContactFlowModuleId").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(UpdateContactFlowModuleContentRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            CONTACT_FLOW_MODULE_ID_FIELD, CONTENT_FIELD));

    private final String instanceId;

    private final String contactFlowModuleId;

    private final String content;

    private UpdateContactFlowModuleContentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.contactFlowModuleId = builder.contactFlowModuleId;
        this.content = builder.content;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the flow module.
     * </p>
     * 
     * @return The identifier of the flow module.
     */
    public final String contactFlowModuleId() {
        return contactFlowModuleId;
    }

    /**
     * <p>
     * The JSON string that represents the content of the flow. For an example, see <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon
     * Connect Flow language</a>.
     * </p>
     * 
     * @return The JSON string that represents the content of the flow. For an example, see <a
     *         href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
     *         Amazon Connect Flow language</a>.
     */
    public final String content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(contactFlowModuleId());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContactFlowModuleContentRequest)) {
            return false;
        }
        UpdateContactFlowModuleContentRequest other = (UpdateContactFlowModuleContentRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(contactFlowModuleId(), other.contactFlowModuleId())
                && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateContactFlowModuleContentRequest").add("InstanceId", instanceId())
                .add("ContactFlowModuleId", contactFlowModuleId()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ContactFlowModuleId":
            return Optional.ofNullable(clazz.cast(contactFlowModuleId()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContactFlowModuleContentRequest, T> g) {
        return obj -> g.apply((UpdateContactFlowModuleContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateContactFlowModuleContentRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the flow module.
         * </p>
         * 
         * @param contactFlowModuleId
         *        The identifier of the flow module.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactFlowModuleId(String contactFlowModuleId);

        /**
         * <p>
         * The JSON string that represents the content of the flow. For an example, see <a
         * href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in
         * Amazon Connect Flow language</a>.
         * </p>
         * 
         * @param content
         *        The JSON string that represents the content of the flow. For an example, see <a
         *        href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow
         *        in Amazon Connect Flow language</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String contactFlowModuleId;

        private String content;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContactFlowModuleContentRequest model) {
            super(model);
            instanceId(model.instanceId);
            contactFlowModuleId(model.contactFlowModuleId);
            content(model.content);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getContactFlowModuleId() {
            return contactFlowModuleId;
        }

        public final void setContactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
        }

        @Override
        public final Builder contactFlowModuleId(String contactFlowModuleId) {
            this.contactFlowModuleId = contactFlowModuleId;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContactFlowModuleContentRequest build() {
            return new UpdateContactFlowModuleContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
