/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The property is not valid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyValidationException extends ConnectException implements
        ToCopyableBuilder<PropertyValidationException.Builder, PropertyValidationException> {
    private static final SdkField<List<PropertyValidationExceptionProperty>> PROPERTY_LIST_FIELD = SdkField
            .<List<PropertyValidationExceptionProperty>> builder(MarshallingType.LIST)
            .memberName("PropertyList")
            .getter(getter(PropertyValidationException::propertyList))
            .setter(setter(Builder::propertyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyValidationExceptionProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyValidationExceptionProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PropertyValidationExceptionProperty> propertyList;

    private PropertyValidationException(BuilderImpl builder) {
        super(builder);
        this.propertyList = builder.propertyList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropertyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasPropertyList() {
        return propertyList != null && !(propertyList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the PropertyList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropertyList} method.
     * </p>
     * 
     * @return The value of the PropertyList property for this object.
     */
    public List<PropertyValidationExceptionProperty> propertyList() {
        return propertyList;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyValidationException, T> g) {
        return obj -> g.apply((PropertyValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyValidationException>, ConnectException.Builder {
        /**
         * Sets the value of the PropertyList property for this object.
         *
         * @param propertyList
         *        The new value for the PropertyList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyList(Collection<PropertyValidationExceptionProperty> propertyList);

        /**
         * Sets the value of the PropertyList property for this object.
         *
         * @param propertyList
         *        The new value for the PropertyList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propertyList(PropertyValidationExceptionProperty... propertyList);

        /**
         * Sets the value of the PropertyList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.PropertyValidationExceptionProperty.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.PropertyValidationExceptionProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.PropertyValidationExceptionProperty.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #propertyList(List<PropertyValidationExceptionProperty>)}.
         * 
         * @param propertyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.PropertyValidationExceptionProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propertyList(java.util.Collection<PropertyValidationExceptionProperty>)
         */
        Builder propertyList(Consumer<PropertyValidationExceptionProperty.Builder>... propertyList);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ConnectException.BuilderImpl implements Builder {
        private List<PropertyValidationExceptionProperty> propertyList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValidationException model) {
            super(model);
            propertyList(model.propertyList);
        }

        public final List<PropertyValidationExceptionProperty.Builder> getPropertyList() {
            List<PropertyValidationExceptionProperty.Builder> result = PropertyValidationExceptionPropertyListCopier
                    .copyToBuilder(this.propertyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyList(Collection<PropertyValidationExceptionProperty.BuilderImpl> propertyList) {
            this.propertyList = PropertyValidationExceptionPropertyListCopier.copyFromBuilder(propertyList);
        }

        @Override
        public final Builder propertyList(Collection<PropertyValidationExceptionProperty> propertyList) {
            this.propertyList = PropertyValidationExceptionPropertyListCopier.copy(propertyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyList(PropertyValidationExceptionProperty... propertyList) {
            propertyList(Arrays.asList(propertyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyList(Consumer<PropertyValidationExceptionProperty.Builder>... propertyList) {
            propertyList(Stream.of(propertyList).map(c -> PropertyValidationExceptionProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public PropertyValidationException build() {
            return new PropertyValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
