/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The storage configuration for the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceStorageConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceStorageConfig.Builder, InstanceStorageConfig> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(InstanceStorageConfig::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(InstanceStorageConfig::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("S3Config").getter(getter(InstanceStorageConfig::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Config").build()).build();

    private static final SdkField<KinesisVideoStreamConfig> KINESIS_VIDEO_STREAM_CONFIG_FIELD = SdkField
            .<KinesisVideoStreamConfig> builder(MarshallingType.SDK_POJO).memberName("KinesisVideoStreamConfig")
            .getter(getter(InstanceStorageConfig::kinesisVideoStreamConfig)).setter(setter(Builder::kinesisVideoStreamConfig))
            .constructor(KinesisVideoStreamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisVideoStreamConfig").build())
            .build();

    private static final SdkField<KinesisStreamConfig> KINESIS_STREAM_CONFIG_FIELD = SdkField
            .<KinesisStreamConfig> builder(MarshallingType.SDK_POJO).memberName("KinesisStreamConfig")
            .getter(getter(InstanceStorageConfig::kinesisStreamConfig)).setter(setter(Builder::kinesisStreamConfig))
            .constructor(KinesisStreamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamConfig").build())
            .build();

    private static final SdkField<KinesisFirehoseConfig> KINESIS_FIREHOSE_CONFIG_FIELD = SdkField
            .<KinesisFirehoseConfig> builder(MarshallingType.SDK_POJO).memberName("KinesisFirehoseConfig")
            .getter(getter(InstanceStorageConfig::kinesisFirehoseConfig)).setter(setter(Builder::kinesisFirehoseConfig))
            .constructor(KinesisFirehoseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisFirehoseConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            STORAGE_TYPE_FIELD, S3_CONFIG_FIELD, KINESIS_VIDEO_STREAM_CONFIG_FIELD, KINESIS_STREAM_CONFIG_FIELD,
            KINESIS_FIREHOSE_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String associationId;

    private final String storageType;

    private final S3Config s3Config;

    private final KinesisVideoStreamConfig kinesisVideoStreamConfig;

    private final KinesisStreamConfig kinesisStreamConfig;

    private final KinesisFirehoseConfig kinesisFirehoseConfig;

    private InstanceStorageConfig(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.storageType = builder.storageType;
        this.s3Config = builder.s3Config;
        this.kinesisVideoStreamConfig = builder.kinesisVideoStreamConfig;
        this.kinesisStreamConfig = builder.kinesisStreamConfig;
        this.kinesisFirehoseConfig = builder.kinesisFirehoseConfig;
    }

    /**
     * <p>
     * The existing association identifier that uniquely identifies the resource type and storage config for the given
     * instance ID.
     * </p>
     * 
     * @return The existing association identifier that uniquely identifies the resource type and storage config for the
     *         given instance ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * A valid storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return A valid storage type.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * A valid storage type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return A valid storage type.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The S3 bucket configuration.
     * </p>
     * 
     * @return The S3 bucket configuration.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    /**
     * <p>
     * The configuration of the Kinesis video stream.
     * </p>
     * 
     * @return The configuration of the Kinesis video stream.
     */
    public final KinesisVideoStreamConfig kinesisVideoStreamConfig() {
        return kinesisVideoStreamConfig;
    }

    /**
     * <p>
     * The configuration of the Kinesis data stream.
     * </p>
     * 
     * @return The configuration of the Kinesis data stream.
     */
    public final KinesisStreamConfig kinesisStreamConfig() {
        return kinesisStreamConfig;
    }

    /**
     * <p>
     * The configuration of the Kinesis Firehose delivery stream.
     * </p>
     * 
     * @return The configuration of the Kinesis Firehose delivery stream.
     */
    public final KinesisFirehoseConfig kinesisFirehoseConfig() {
        return kinesisFirehoseConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisVideoStreamConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisFirehoseConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageConfig)) {
            return false;
        }
        InstanceStorageConfig other = (InstanceStorageConfig) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(s3Config(), other.s3Config())
                && Objects.equals(kinesisVideoStreamConfig(), other.kinesisVideoStreamConfig())
                && Objects.equals(kinesisStreamConfig(), other.kinesisStreamConfig())
                && Objects.equals(kinesisFirehoseConfig(), other.kinesisFirehoseConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceStorageConfig").add("AssociationId", associationId())
                .add("StorageType", storageTypeAsString()).add("S3Config", s3Config())
                .add("KinesisVideoStreamConfig", kinesisVideoStreamConfig()).add("KinesisStreamConfig", kinesisStreamConfig())
                .add("KinesisFirehoseConfig", kinesisFirehoseConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "S3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "KinesisVideoStreamConfig":
            return Optional.ofNullable(clazz.cast(kinesisVideoStreamConfig()));
        case "KinesisStreamConfig":
            return Optional.ofNullable(clazz.cast(kinesisStreamConfig()));
        case "KinesisFirehoseConfig":
            return Optional.ofNullable(clazz.cast(kinesisFirehoseConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceStorageConfig, T> g) {
        return obj -> g.apply((InstanceStorageConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceStorageConfig> {
        /**
         * <p>
         * The existing association identifier that uniquely identifies the resource type and storage config for the
         * given instance ID.
         * </p>
         * 
         * @param associationId
         *        The existing association identifier that uniquely identifies the resource type and storage config for
         *        the given instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageType
         *        A valid storage type.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * A valid storage type.
         * </p>
         * 
         * @param storageType
         *        A valid storage type.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The S3 bucket configuration.
         * </p>
         * 
         * @param s3Config
         *        The S3 bucket configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * <p>
         * The S3 bucket configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * <p>
         * The configuration of the Kinesis video stream.
         * </p>
         * 
         * @param kinesisVideoStreamConfig
         *        The configuration of the Kinesis video stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisVideoStreamConfig(KinesisVideoStreamConfig kinesisVideoStreamConfig);

        /**
         * <p>
         * The configuration of the Kinesis video stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisVideoStreamConfig.Builder}
         * avoiding the need to create one manually via {@link KinesisVideoStreamConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisVideoStreamConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #kinesisVideoStreamConfig(KinesisVideoStreamConfig)}.
         * 
         * @param kinesisVideoStreamConfig
         *        a consumer that will call methods on {@link KinesisVideoStreamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisVideoStreamConfig(KinesisVideoStreamConfig)
         */
        default Builder kinesisVideoStreamConfig(Consumer<KinesisVideoStreamConfig.Builder> kinesisVideoStreamConfig) {
            return kinesisVideoStreamConfig(KinesisVideoStreamConfig.builder().applyMutation(kinesisVideoStreamConfig).build());
        }

        /**
         * <p>
         * The configuration of the Kinesis data stream.
         * </p>
         * 
         * @param kinesisStreamConfig
         *        The configuration of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig);

        /**
         * <p>
         * The configuration of the Kinesis data stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisStreamConfig.Builder} avoiding the
         * need to create one manually via {@link KinesisStreamConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisStreamConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisStreamConfig(KinesisStreamConfig)}.
         * 
         * @param kinesisStreamConfig
         *        a consumer that will call methods on {@link KinesisStreamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisStreamConfig(KinesisStreamConfig)
         */
        default Builder kinesisStreamConfig(Consumer<KinesisStreamConfig.Builder> kinesisStreamConfig) {
            return kinesisStreamConfig(KinesisStreamConfig.builder().applyMutation(kinesisStreamConfig).build());
        }

        /**
         * <p>
         * The configuration of the Kinesis Firehose delivery stream.
         * </p>
         * 
         * @param kinesisFirehoseConfig
         *        The configuration of the Kinesis Firehose delivery stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisFirehoseConfig(KinesisFirehoseConfig kinesisFirehoseConfig);

        /**
         * <p>
         * The configuration of the Kinesis Firehose delivery stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link KinesisFirehoseConfig.Builder} avoiding
         * the need to create one manually via {@link KinesisFirehoseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KinesisFirehoseConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisFirehoseConfig(KinesisFirehoseConfig)}.
         * 
         * @param kinesisFirehoseConfig
         *        a consumer that will call methods on {@link KinesisFirehoseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisFirehoseConfig(KinesisFirehoseConfig)
         */
        default Builder kinesisFirehoseConfig(Consumer<KinesisFirehoseConfig.Builder> kinesisFirehoseConfig) {
            return kinesisFirehoseConfig(KinesisFirehoseConfig.builder().applyMutation(kinesisFirehoseConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String associationId;

        private String storageType;

        private S3Config s3Config;

        private KinesisVideoStreamConfig kinesisVideoStreamConfig;

        private KinesisStreamConfig kinesisStreamConfig;

        private KinesisFirehoseConfig kinesisFirehoseConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStorageConfig model) {
            associationId(model.associationId);
            storageType(model.storageType);
            s3Config(model.s3Config);
            kinesisVideoStreamConfig(model.kinesisVideoStreamConfig);
            kinesisStreamConfig(model.kinesisStreamConfig);
            kinesisFirehoseConfig(model.kinesisFirehoseConfig);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final KinesisVideoStreamConfig.Builder getKinesisVideoStreamConfig() {
            return kinesisVideoStreamConfig != null ? kinesisVideoStreamConfig.toBuilder() : null;
        }

        public final void setKinesisVideoStreamConfig(KinesisVideoStreamConfig.BuilderImpl kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig != null ? kinesisVideoStreamConfig.build() : null;
        }

        @Override
        public final Builder kinesisVideoStreamConfig(KinesisVideoStreamConfig kinesisVideoStreamConfig) {
            this.kinesisVideoStreamConfig = kinesisVideoStreamConfig;
            return this;
        }

        public final KinesisStreamConfig.Builder getKinesisStreamConfig() {
            return kinesisStreamConfig != null ? kinesisStreamConfig.toBuilder() : null;
        }

        public final void setKinesisStreamConfig(KinesisStreamConfig.BuilderImpl kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig != null ? kinesisStreamConfig.build() : null;
        }

        @Override
        public final Builder kinesisStreamConfig(KinesisStreamConfig kinesisStreamConfig) {
            this.kinesisStreamConfig = kinesisStreamConfig;
            return this;
        }

        public final KinesisFirehoseConfig.Builder getKinesisFirehoseConfig() {
            return kinesisFirehoseConfig != null ? kinesisFirehoseConfig.toBuilder() : null;
        }

        public final void setKinesisFirehoseConfig(KinesisFirehoseConfig.BuilderImpl kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig != null ? kinesisFirehoseConfig.build() : null;
        }

        @Override
        public final Builder kinesisFirehoseConfig(KinesisFirehoseConfig kinesisFirehoseConfig) {
            this.kinesisFirehoseConfig = kinesisFirehoseConfig;
            return this;
        }

        @Override
        public InstanceStorageConfig build() {
            return new InstanceStorageConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
