/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about of the hours of operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HoursOfOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<HoursOfOperation.Builder, HoursOfOperation> {
    private static final SdkField<String> HOURS_OF_OPERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationId").getter(getter(HoursOfOperation::hoursOfOperationId))
            .setter(setter(Builder::hoursOfOperationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationId").build())
            .build();

    private static final SdkField<String> HOURS_OF_OPERATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HoursOfOperationArn").getter(getter(HoursOfOperation::hoursOfOperationArn))
            .setter(setter(Builder::hoursOfOperationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HoursOfOperationArn").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(HoursOfOperation::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(HoursOfOperation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZone").getter(getter(HoursOfOperation::timeZone)).setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZone").build()).build();

    private static final SdkField<List<HoursOfOperationConfig>> CONFIG_FIELD = SdkField
            .<List<HoursOfOperationConfig>> builder(MarshallingType.LIST)
            .memberName("Config")
            .getter(getter(HoursOfOperation::config))
            .setter(setter(Builder::config))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HoursOfOperationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(HoursOfOperationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(HoursOfOperation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(HoursOfOperation::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> LAST_MODIFIED_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedRegion").getter(getter(HoursOfOperation::lastModifiedRegion))
            .setter(setter(Builder::lastModifiedRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedRegion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURS_OF_OPERATION_ID_FIELD,
            HOURS_OF_OPERATION_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TIME_ZONE_FIELD, CONFIG_FIELD, TAGS_FIELD,
            LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hoursOfOperationId;

    private final String hoursOfOperationArn;

    private final String name;

    private final String description;

    private final String timeZone;

    private final List<HoursOfOperationConfig> config;

    private final Map<String, String> tags;

    private final Instant lastModifiedTime;

    private final String lastModifiedRegion;

    private HoursOfOperation(BuilderImpl builder) {
        this.hoursOfOperationId = builder.hoursOfOperationId;
        this.hoursOfOperationArn = builder.hoursOfOperationArn;
        this.name = builder.name;
        this.description = builder.description;
        this.timeZone = builder.timeZone;
        this.config = builder.config;
        this.tags = builder.tags;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedRegion = builder.lastModifiedRegion;
    }

    /**
     * <p>
     * The identifier for the hours of operation.
     * </p>
     * 
     * @return The identifier for the hours of operation.
     */
    public final String hoursOfOperationId() {
        return hoursOfOperationId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the hours of operation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the hours of operation.
     */
    public final String hoursOfOperationArn() {
        return hoursOfOperationArn;
    }

    /**
     * <p>
     * The name for the hours of operation.
     * </p>
     * 
     * @return The name for the hours of operation.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description for the hours of operation.
     * </p>
     * 
     * @return The description for the hours of operation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time zone for the hours of operation.
     * </p>
     * 
     * @return The time zone for the hours of operation.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the Config property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConfig() {
        return config != null && !(config instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration information for the hours of operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfig} method.
     * </p>
     * 
     * @return Configuration information for the hours of operation.
     */
    public final List<HoursOfOperationConfig> config() {
        return config;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1",
     * "key2":"value2"} }.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource. For example, { "tags":
     *         {"key1":"value1", "key2":"value2"} }.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The timestamp when this resource was last modified.
     * </p>
     * 
     * @return The timestamp when this resource was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The Amazon Web Services Region where this resource was last modified.
     * </p>
     * 
     * @return The Amazon Web Services Region where this resource was last modified.
     */
    public final String lastModifiedRegion() {
        return lastModifiedRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationId());
        hashCode = 31 * hashCode + Objects.hashCode(hoursOfOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfig() ? config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HoursOfOperation)) {
            return false;
        }
        HoursOfOperation other = (HoursOfOperation) obj;
        return Objects.equals(hoursOfOperationId(), other.hoursOfOperationId())
                && Objects.equals(hoursOfOperationArn(), other.hoursOfOperationArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(timeZone(), other.timeZone())
                && hasConfig() == other.hasConfig() && Objects.equals(config(), other.config()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedRegion(), other.lastModifiedRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HoursOfOperation").add("HoursOfOperationId", hoursOfOperationId())
                .add("HoursOfOperationArn", hoursOfOperationArn()).add("Name", name()).add("Description", description())
                .add("TimeZone", timeZone()).add("Config", hasConfig() ? config() : null).add("Tags", hasTags() ? tags() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("LastModifiedRegion", lastModifiedRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HoursOfOperationId":
            return Optional.ofNullable(clazz.cast(hoursOfOperationId()));
        case "HoursOfOperationArn":
            return Optional.ofNullable(clazz.cast(hoursOfOperationArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TimeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedRegion":
            return Optional.ofNullable(clazz.cast(lastModifiedRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HoursOfOperation, T> g) {
        return obj -> g.apply((HoursOfOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HoursOfOperation> {
        /**
         * <p>
         * The identifier for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationId
         *        The identifier for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationId(String hoursOfOperationId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the hours of operation.
         * </p>
         * 
         * @param hoursOfOperationArn
         *        The Amazon Resource Name (ARN) for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hoursOfOperationArn(String hoursOfOperationArn);

        /**
         * <p>
         * The name for the hours of operation.
         * </p>
         * 
         * @param name
         *        The name for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description for the hours of operation.
         * </p>
         * 
         * @param description
         *        The description for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time zone for the hours of operation.
         * </p>
         * 
         * @param timeZone
         *        The time zone for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Configuration information for the hours of operation.
         * </p>
         * 
         * @param config
         *        Configuration information for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(Collection<HoursOfOperationConfig> config);

        /**
         * <p>
         * Configuration information for the hours of operation.
         * </p>
         * 
         * @param config
         *        Configuration information for the hours of operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(HoursOfOperationConfig... config);

        /**
         * <p>
         * Configuration information for the hours of operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #config(List<HoursOfOperationConfig>)}.
         * 
         * @param config
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.HoursOfOperationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(java.util.Collection<HoursOfOperationConfig>)
         */
        Builder config(Consumer<HoursOfOperationConfig.Builder>... config);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource. For example, { "tags":
         * {"key1":"value1", "key2":"value2"} }.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource. For example, { "tags":
         *        {"key1":"value1", "key2":"value2"} }.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The timestamp when this resource was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp when this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The Amazon Web Services Region where this resource was last modified.
         * </p>
         * 
         * @param lastModifiedRegion
         *        The Amazon Web Services Region where this resource was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedRegion(String lastModifiedRegion);
    }

    static final class BuilderImpl implements Builder {
        private String hoursOfOperationId;

        private String hoursOfOperationArn;

        private String name;

        private String description;

        private String timeZone;

        private List<HoursOfOperationConfig> config = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Instant lastModifiedTime;

        private String lastModifiedRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(HoursOfOperation model) {
            hoursOfOperationId(model.hoursOfOperationId);
            hoursOfOperationArn(model.hoursOfOperationArn);
            name(model.name);
            description(model.description);
            timeZone(model.timeZone);
            config(model.config);
            tags(model.tags);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedRegion(model.lastModifiedRegion);
        }

        public final String getHoursOfOperationId() {
            return hoursOfOperationId;
        }

        public final void setHoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
        }

        @Override
        public final Builder hoursOfOperationId(String hoursOfOperationId) {
            this.hoursOfOperationId = hoursOfOperationId;
            return this;
        }

        public final String getHoursOfOperationArn() {
            return hoursOfOperationArn;
        }

        public final void setHoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
        }

        @Override
        public final Builder hoursOfOperationArn(String hoursOfOperationArn) {
            this.hoursOfOperationArn = hoursOfOperationArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final List<HoursOfOperationConfig.Builder> getConfig() {
            List<HoursOfOperationConfig.Builder> result = HoursOfOperationConfigListCopier.copyToBuilder(this.config);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfig(Collection<HoursOfOperationConfig.BuilderImpl> config) {
            this.config = HoursOfOperationConfigListCopier.copyFromBuilder(config);
        }

        @Override
        public final Builder config(Collection<HoursOfOperationConfig> config) {
            this.config = HoursOfOperationConfigListCopier.copy(config);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(HoursOfOperationConfig... config) {
            config(Arrays.asList(config));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder config(Consumer<HoursOfOperationConfig.Builder>... config) {
            config(Stream.of(config).map(c -> HoursOfOperationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getLastModifiedRegion() {
            return lastModifiedRegion;
        }

        public final void setLastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
        }

        @Override
        public final Builder lastModifiedRegion(String lastModifiedRegion) {
            this.lastModifiedRegion = lastModifiedRegion;
            return this;
        }

        @Override
        public HoursOfOperation build() {
            return new HoursOfOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
