/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteUseCaseRequest extends ConnectRequest implements
        ToCopyableBuilder<DeleteUseCaseRequest.Builder, DeleteUseCaseRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DeleteUseCaseRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> INTEGRATION_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IntegrationAssociationId").getter(getter(DeleteUseCaseRequest::integrationAssociationId))
            .setter(setter(Builder::integrationAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("IntegrationAssociationId").build())
            .build();

    private static final SdkField<String> USE_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UseCaseId").getter(getter(DeleteUseCaseRequest::useCaseId)).setter(setter(Builder::useCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UseCaseId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            INTEGRATION_ASSOCIATION_ID_FIELD, USE_CASE_ID_FIELD));

    private final String instanceId;

    private final String integrationAssociationId;

    private final String useCaseId;

    private DeleteUseCaseRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.integrationAssociationId = builder.integrationAssociationId;
        this.useCaseId = builder.useCaseId;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in
     * the Amazon Resource Name (ARN) of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can <a
     *         href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
     *         ID</a> in the Amazon Resource Name (ARN) of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier for the integration association.
     * </p>
     * 
     * @return The identifier for the integration association.
     */
    public final String integrationAssociationId() {
        return integrationAssociationId;
    }

    /**
     * <p>
     * The identifier for the use case.
     * </p>
     * 
     * @return The identifier for the use case.
     */
    public final String useCaseId() {
        return useCaseId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(integrationAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(useCaseId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteUseCaseRequest)) {
            return false;
        }
        DeleteUseCaseRequest other = (DeleteUseCaseRequest) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(integrationAssociationId(), other.integrationAssociationId())
                && Objects.equals(useCaseId(), other.useCaseId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteUseCaseRequest").add("InstanceId", instanceId())
                .add("IntegrationAssociationId", integrationAssociationId()).add("UseCaseId", useCaseId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "IntegrationAssociationId":
            return Optional.ofNullable(clazz.cast(integrationAssociationId()));
        case "UseCaseId":
            return Optional.ofNullable(clazz.cast(useCaseId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteUseCaseRequest, T> g) {
        return obj -> g.apply((DeleteUseCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteUseCaseRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can <a
         * href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a>
         * in the Amazon Resource Name (ARN) of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can <a
         *        href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance
         *        ID</a> in the Amazon Resource Name (ARN) of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier for the integration association.
         * </p>
         * 
         * @param integrationAssociationId
         *        The identifier for the integration association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integrationAssociationId(String integrationAssociationId);

        /**
         * <p>
         * The identifier for the use case.
         * </p>
         * 
         * @param useCaseId
         *        The identifier for the use case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCaseId(String useCaseId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String integrationAssociationId;

        private String useCaseId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteUseCaseRequest model) {
            super(model);
            instanceId(model.instanceId);
            integrationAssociationId(model.integrationAssociationId);
            useCaseId(model.useCaseId);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getIntegrationAssociationId() {
            return integrationAssociationId;
        }

        public final void setIntegrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
        }

        @Override
        public final Builder integrationAssociationId(String integrationAssociationId) {
            this.integrationAssociationId = integrationAssociationId;
            return this;
        }

        public final String getUseCaseId() {
            return useCaseId;
        }

        public final void setUseCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
        }

        @Override
        public final Builder useCaseId(String useCaseId) {
            this.useCaseId = useCaseId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteUseCaseRequest build() {
            return new DeleteUseCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
