/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectAsyncClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListViewVersionsRequest;
import software.amazon.awssdk.services.connect.model.ListViewVersionsResponse;
import software.amazon.awssdk.services.connect.model.ViewVersionSummary;

public class ListViewVersionsPublisher
implements SdkPublisher<ListViewVersionsResponse> {
    private final ConnectAsyncClient client;
    private final ListViewVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListViewVersionsPublisher(ConnectAsyncClient client, ListViewVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListViewVersionsPublisher(ConnectAsyncClient client, ListViewVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListViewVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListViewVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ViewVersionSummary> viewVersionSummaryList() {
        Function<ListViewVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.viewVersionSummaryList() != null) {
                return response.viewVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListViewVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListViewVersionsResponseFetcher
    implements AsyncPageFetcher<ListViewVersionsResponse> {
        private ListViewVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListViewVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListViewVersionsResponse> nextPage(ListViewVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListViewVersionsPublisher.this.client.listViewVersions(ListViewVersionsPublisher.this.firstRequest);
            }
            return ListViewVersionsPublisher.this.client.listViewVersions((ListViewVersionsRequest)((Object)ListViewVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

