/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connect.ConnectClient;
import software.amazon.awssdk.services.connect.internal.UserAgentUtils;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersRequest;
import software.amazon.awssdk.services.connect.model.ListPhoneNumbersResponse;
import software.amazon.awssdk.services.connect.model.PhoneNumberSummary;

public class ListPhoneNumbersIterable
implements SdkIterable<ListPhoneNumbersResponse> {
    private final ConnectClient client;
    private final ListPhoneNumbersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPhoneNumbersIterable(ConnectClient client, ListPhoneNumbersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPhoneNumbersResponseFetcher();
    }

    public Iterator<ListPhoneNumbersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PhoneNumberSummary> phoneNumberSummaryList() {
        Function<ListPhoneNumbersResponse, Iterator> getIterator = response -> {
            if (response != null && response.phoneNumberSummaryList() != null) {
                return response.phoneNumberSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPhoneNumbersResponseFetcher
    implements SyncPageFetcher<ListPhoneNumbersResponse> {
        private ListPhoneNumbersResponseFetcher() {
        }

        public boolean hasNextPage(ListPhoneNumbersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPhoneNumbersResponse nextPage(ListPhoneNumbersResponse previousPage) {
            if (previousPage == null) {
                return ListPhoneNumbersIterable.this.client.listPhoneNumbers(ListPhoneNumbersIterable.this.firstRequest);
            }
            return ListPhoneNumbersIterable.this.client.listPhoneNumbers((ListPhoneNumbersRequest)((Object)ListPhoneNumbersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

