/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connect.model.PhoneNumberCountryCode;
import software.amazon.awssdk.services.connect.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPhoneNumbersSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListPhoneNumbersSummary> {
    private static final SdkField<String> PHONE_NUMBER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberId").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::phoneNumberId)).setter(ListPhoneNumbersSummary.setter(Builder::phoneNumberId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberId").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberArn").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::phoneNumberArn)).setter(ListPhoneNumbersSummary.setter(Builder::phoneNumberArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberArn").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::phoneNumber)).setter(ListPhoneNumbersSummary.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberCountryCode").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::phoneNumberCountryCodeAsString)).setter(ListPhoneNumbersSummary.setter(Builder::phoneNumberCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberCountryCode").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberType").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::phoneNumberTypeAsString)).setter(ListPhoneNumbersSummary.setter(Builder::phoneNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumberType").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetArn").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::targetArn)).setter(ListPhoneNumbersSummary.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetArn").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ListPhoneNumbersSummary.getter(ListPhoneNumbersSummary::instanceId)).setter(ListPhoneNumbersSummary.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PHONE_NUMBER_ID_FIELD, PHONE_NUMBER_ARN_FIELD, PHONE_NUMBER_FIELD, PHONE_NUMBER_COUNTRY_CODE_FIELD, PHONE_NUMBER_TYPE_FIELD, TARGET_ARN_FIELD, INSTANCE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String phoneNumberId;
    private final String phoneNumberArn;
    private final String phoneNumber;
    private final String phoneNumberCountryCode;
    private final String phoneNumberType;
    private final String targetArn;
    private final String instanceId;

    private ListPhoneNumbersSummary(BuilderImpl builder) {
        this.phoneNumberId = builder.phoneNumberId;
        this.phoneNumberArn = builder.phoneNumberArn;
        this.phoneNumber = builder.phoneNumber;
        this.phoneNumberCountryCode = builder.phoneNumberCountryCode;
        this.phoneNumberType = builder.phoneNumberType;
        this.targetArn = builder.targetArn;
        this.instanceId = builder.instanceId;
    }

    public final String phoneNumberId() {
        return this.phoneNumberId;
    }

    public final String phoneNumberArn() {
        return this.phoneNumberArn;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final PhoneNumberCountryCode phoneNumberCountryCode() {
        return PhoneNumberCountryCode.fromValue(this.phoneNumberCountryCode);
    }

    public final String phoneNumberCountryCodeAsString() {
        return this.phoneNumberCountryCode;
    }

    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(this.phoneNumberType);
    }

    public final String phoneNumberTypeAsString() {
        return this.phoneNumberType;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberId());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberCountryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPhoneNumbersSummary)) {
            return false;
        }
        ListPhoneNumbersSummary other = (ListPhoneNumbersSummary)obj;
        return Objects.equals(this.phoneNumberId(), other.phoneNumberId()) && Objects.equals(this.phoneNumberArn(), other.phoneNumberArn()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.phoneNumberCountryCodeAsString(), other.phoneNumberCountryCodeAsString()) && Objects.equals(this.phoneNumberTypeAsString(), other.phoneNumberTypeAsString()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.instanceId(), other.instanceId());
    }

    public final String toString() {
        return ToString.builder((String)"ListPhoneNumbersSummary").add("PhoneNumberId", (Object)this.phoneNumberId()).add("PhoneNumberArn", (Object)this.phoneNumberArn()).add("PhoneNumber", (Object)this.phoneNumber()).add("PhoneNumberCountryCode", (Object)this.phoneNumberCountryCodeAsString()).add("PhoneNumberType", (Object)this.phoneNumberTypeAsString()).add("TargetArn", (Object)this.targetArn()).add("InstanceId", (Object)this.instanceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PhoneNumberId": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberId()));
            }
            case "PhoneNumberArn": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberArn()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "PhoneNumberCountryCode": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberCountryCodeAsString()));
            }
            case "PhoneNumberType": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypeAsString()));
            }
            case "TargetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPhoneNumbersSummary, T> g) {
        return obj -> g.apply((ListPhoneNumbersSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String phoneNumberId;
        private String phoneNumberArn;
        private String phoneNumber;
        private String phoneNumberCountryCode;
        private String phoneNumberType;
        private String targetArn;
        private String instanceId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPhoneNumbersSummary model) {
            this.phoneNumberId(model.phoneNumberId);
            this.phoneNumberArn(model.phoneNumberArn);
            this.phoneNumber(model.phoneNumber);
            this.phoneNumberCountryCode(model.phoneNumberCountryCode);
            this.phoneNumberType(model.phoneNumberType);
            this.targetArn(model.targetArn);
            this.instanceId(model.instanceId);
        }

        public final String getPhoneNumberId() {
            return this.phoneNumberId;
        }

        public final void setPhoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
        }

        @Override
        public final Builder phoneNumberId(String phoneNumberId) {
            this.phoneNumberId = phoneNumberId;
            return this;
        }

        public final String getPhoneNumberArn() {
            return this.phoneNumberArn;
        }

        public final void setPhoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
        }

        @Override
        public final Builder phoneNumberArn(String phoneNumberArn) {
            this.phoneNumberArn = phoneNumberArn;
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getPhoneNumberCountryCode() {
            return this.phoneNumberCountryCode;
        }

        public final void setPhoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
        }

        @Override
        public final Builder phoneNumberCountryCode(String phoneNumberCountryCode) {
            this.phoneNumberCountryCode = phoneNumberCountryCode;
            return this;
        }

        @Override
        public final Builder phoneNumberCountryCode(PhoneNumberCountryCode phoneNumberCountryCode) {
            this.phoneNumberCountryCode(phoneNumberCountryCode == null ? null : phoneNumberCountryCode.toString());
            return this;
        }

        public final String getPhoneNumberType() {
            return this.phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public ListPhoneNumbersSummary build() {
            return new ListPhoneNumbersSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListPhoneNumbersSummary> {
        public Builder phoneNumberId(String var1);

        public Builder phoneNumberArn(String var1);

        public Builder phoneNumber(String var1);

        public Builder phoneNumberCountryCode(String var1);

        public Builder phoneNumberCountryCode(PhoneNumberCountryCode var1);

        public Builder phoneNumberType(String var1);

        public Builder phoneNumberType(PhoneNumberType var1);

        public Builder targetArn(String var1);

        public Builder instanceId(String var1);
    }
}

