/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContactFlowType {
    CONTACT_FLOW("CONTACT_FLOW"),
    CUSTOMER_QUEUE("CUSTOMER_QUEUE"),
    CUSTOMER_HOLD("CUSTOMER_HOLD"),
    CUSTOMER_WHISPER("CUSTOMER_WHISPER"),
    AGENT_HOLD("AGENT_HOLD"),
    AGENT_WHISPER("AGENT_WHISPER"),
    OUTBOUND_WHISPER("OUTBOUND_WHISPER"),
    AGENT_TRANSFER("AGENT_TRANSFER"),
    QUEUE_TRANSFER("QUEUE_TRANSFER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContactFlowType> VALUE_MAP;
    private final String value;

    private ContactFlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContactFlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContactFlowType> knownValues() {
        EnumSet<ContactFlowType> knownValues = EnumSet.allOf(ContactFlowType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContactFlowType.class, ContactFlowType::toString);
    }
}

