/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connect.model.ConnectRequest;
import software.amazon.awssdk.services.connect.model.ListFlowAssociationResourceType;
import software.amazon.awssdk.services.connect.model._resourceArnListMaxLimit100Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetFlowAssociationRequest
extends ConnectRequest
implements ToCopyableBuilder<Builder, BatchGetFlowAssociationRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(BatchGetFlowAssociationRequest.getter(BatchGetFlowAssociationRequest::instanceId)).setter(BatchGetFlowAssociationRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceIds").getter(BatchGetFlowAssociationRequest.getter(BatchGetFlowAssociationRequest::resourceIds)).setter(BatchGetFlowAssociationRequest.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(BatchGetFlowAssociationRequest.getter(BatchGetFlowAssociationRequest::resourceTypeAsString)).setter(BatchGetFlowAssociationRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, RESOURCE_IDS_FIELD, RESOURCE_TYPE_FIELD));
    private final String instanceId;
    private final List<String> resourceIds;
    private final String resourceType;

    private BatchGetFlowAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public final List<String> resourceIds() {
        return this.resourceIds;
    }

    public final ListFlowAssociationResourceType resourceType() {
        return ListFlowAssociationResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceIds() ? this.resourceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetFlowAssociationRequest)) {
            return false;
        }
        BatchGetFlowAssociationRequest other = (BatchGetFlowAssociationRequest)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && this.hasResourceIds() == other.hasResourceIds() && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetFlowAssociationRequest").add("InstanceId", (Object)this.instanceId()).add("ResourceIds", this.hasResourceIds() ? this.resourceIds() : null).add("ResourceType", (Object)this.resourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetFlowAssociationRequest, T> g) {
        return obj -> g.apply((BatchGetFlowAssociationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectRequest.BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetFlowAssociationRequest model) {
            super(model);
            this.instanceId(model.instanceId);
            this.resourceIds(model.resourceIds);
            this.resourceType(model.resourceType);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getResourceIds() {
            if (this.resourceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceIds;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = _resourceArnListMaxLimit100Copier.copy(resourceIds);
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = _resourceArnListMaxLimit100Copier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ListFlowAssociationResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetFlowAssociationRequest build() {
            return new BatchGetFlowAssociationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetFlowAssociationRequest> {
        public Builder instanceId(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ListFlowAssociationResourceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

