/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigAsyncClient;
import software.amazon.awssdk.services.config.internal.UserAgentUtils;
import software.amazon.awssdk.services.config.model.ComplianceByConfigRule;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleRequest;
import software.amazon.awssdk.services.config.model.DescribeComplianceByConfigRuleResponse;

public class DescribeComplianceByConfigRulePublisher
implements SdkPublisher<DescribeComplianceByConfigRuleResponse> {
    private final ConfigAsyncClient client;
    private final DescribeComplianceByConfigRuleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeComplianceByConfigRulePublisher(ConfigAsyncClient client, DescribeComplianceByConfigRuleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeComplianceByConfigRulePublisher(ConfigAsyncClient client, DescribeComplianceByConfigRuleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeComplianceByConfigRuleResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeComplianceByConfigRuleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComplianceByConfigRule> complianceByConfigRules() {
        Function<DescribeComplianceByConfigRuleResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceByConfigRules() != null) {
                return response.complianceByConfigRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeComplianceByConfigRuleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeComplianceByConfigRuleResponseFetcher
    implements AsyncPageFetcher<DescribeComplianceByConfigRuleResponse> {
        private DescribeComplianceByConfigRuleResponseFetcher() {
        }

        public boolean hasNextPage(DescribeComplianceByConfigRuleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeComplianceByConfigRuleResponse> nextPage(DescribeComplianceByConfigRuleResponse previousPage) {
            if (previousPage == null) {
                return DescribeComplianceByConfigRulePublisher.this.client.describeComplianceByConfigRule(DescribeComplianceByConfigRulePublisher.this.firstRequest);
            }
            return DescribeComplianceByConfigRulePublisher.this.client.describeComplianceByConfigRule((DescribeComplianceByConfigRuleRequest)((Object)DescribeComplianceByConfigRulePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

