/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest;
import software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesResponse;
import software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus;

public class DescribeOrganizationConfigRuleStatusesIterable
implements SdkIterable<DescribeOrganizationConfigRuleStatusesResponse> {
    private final ConfigClient client;
    private final DescribeOrganizationConfigRuleStatusesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeOrganizationConfigRuleStatusesIterable(ConfigClient client, DescribeOrganizationConfigRuleStatusesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrganizationConfigRuleStatusesResponseFetcher();
    }

    public Iterator<DescribeOrganizationConfigRuleStatusesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationConfigRuleStatus> organizationConfigRuleStatuses() {
        Function<DescribeOrganizationConfigRuleStatusesResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationConfigRuleStatuses() != null) {
                return response.organizationConfigRuleStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeOrganizationConfigRuleStatusesResponseFetcher
    implements SyncPageFetcher<DescribeOrganizationConfigRuleStatusesResponse> {
        private DescribeOrganizationConfigRuleStatusesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrganizationConfigRuleStatusesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeOrganizationConfigRuleStatusesResponse nextPage(DescribeOrganizationConfigRuleStatusesResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrganizationConfigRuleStatusesIterable.this.client.describeOrganizationConfigRuleStatuses(DescribeOrganizationConfigRuleStatusesIterable.this.firstRequest);
            }
            return DescribeOrganizationConfigRuleStatusesIterable.this.client.describeOrganizationConfigRuleStatuses((DescribeOrganizationConfigRuleStatusesRequest)((Object)DescribeOrganizationConfigRuleStatusesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

