/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.config.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.config.ConfigClient;
import software.amazon.awssdk.services.config.model.AggregationAuthorization;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsRequest;
import software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse;

public class DescribeAggregationAuthorizationsIterable
implements SdkIterable<DescribeAggregationAuthorizationsResponse> {
    private final ConfigClient client;
    private final DescribeAggregationAuthorizationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAggregationAuthorizationsIterable(ConfigClient client, DescribeAggregationAuthorizationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAggregationAuthorizationsResponseFetcher();
    }

    public Iterator<DescribeAggregationAuthorizationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AggregationAuthorization> aggregationAuthorizations() {
        Function<DescribeAggregationAuthorizationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregationAuthorizations() != null) {
                return response.aggregationAuthorizations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeAggregationAuthorizationsResponseFetcher
    implements SyncPageFetcher<DescribeAggregationAuthorizationsResponse> {
        private DescribeAggregationAuthorizationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAggregationAuthorizationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeAggregationAuthorizationsResponse nextPage(DescribeAggregationAuthorizationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAggregationAuthorizationsIterable.this.client.describeAggregationAuthorizations(DescribeAggregationAuthorizationsIterable.this.firstRequest);
            }
            return DescribeAggregationAuthorizationsIterable.this.client.describeAggregationAuthorizations((DescribeAggregationAuthorizationsRequest)((Object)DescribeAggregationAuthorizationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

